/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.EnclosingType;
import com.squareup.wire.schema.Extensions;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.OneOf;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Reserved;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.GroupElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MessageType
extends Type {
    public static final String XSD_MESSAGE_OPTIONS_PACKAGE = "xsd";
    public static final String BASE_TYPE_MESSAGE_OPTION = "base_type";
    public static final String XSD_BASE_TYPE_MESSAGE_OPTION_NAME = "xsd.base_type";
    public static final int FIELD_NUM_INCREMENT = 10;
    private ProtoType protoType;
    private final Location location;
    private String documentation;
    private String name;
    private List<Field> declaredFields;
    private final List<Field> extensionFields;
    private final List<OneOf> oneOfs;
    private final List<Type> nestedTypes;
    private final List<Extensions> extensionsList;
    private final List<Reserved> reserveds;
    private final Options options;
    private int fieldNum = 0;
    private boolean wrapperMessageType = false;

    public boolean isWrapperMessageType() {
        return this.wrapperMessageType;
    }

    public void setWrapperMessageType(boolean wrapperMessageType) {
        this.wrapperMessageType = wrapperMessageType;
    }

    public MessageType(ProtoType protoType, Location location, String documentation, String name, List<Field> declaredFields, List<Field> extensionFields, List<OneOf> oneOfs, List<Type> nestedTypes, List<Extensions> extensionsList, List<Reserved> reserveds, Options options) {
        this.protoType = protoType;
        this.location = location;
        this.documentation = documentation;
        this.name = name;
        this.declaredFields = declaredFields;
        this.extensionFields = extensionFields;
        this.oneOfs = oneOfs;
        this.nestedTypes = nestedTypes;
        this.extensionsList = extensionsList;
        this.reserveds = reserveds;
        this.options = (Options)Preconditions.checkNotNull((Object)options);
    }

    public MessageType(ProtoType protoType, Location location, String documentation, String name, Options options) {
        this.protoType = protoType;
        this.location = location;
        this.documentation = documentation;
        this.name = name;
        this.options = (Options)Preconditions.checkNotNull((Object)options);
        this.declaredFields = new ArrayList<Field>();
        this.extensionFields = new ArrayList<Field>();
        this.extensionsList = new ArrayList<Extensions>();
        this.oneOfs = new ArrayList<OneOf>();
        this.nestedTypes = new ArrayList<Type>();
        this.reserveds = new ArrayList<Reserved>();
    }

    public List<Reserved> getReserveds() {
        return this.reserveds;
    }

    public void addReserved(Reserved r) {
        this.reserveds.add(r);
    }

    public String toString() {
        return "MessageType [name=" + this.name + "]";
    }

    public int getNextFieldNum() {
        ++this.fieldNum;
        return this.fieldNum;
    }

    public void advanceFieldNum() {
        if (this.fieldNum == 0) {
            return;
        }
        int newFieldNum = this.fieldNum + 10 - this.fieldNum % 10;
        if (newFieldNum - 3 < this.fieldNum) {
            this.fieldNum = newFieldNum;
            this.advanceFieldNum();
        } else {
            this.fieldNum = newFieldNum;
        }
    }

    public String getName() {
        return this.name;
    }

    public void updateName(String newName) {
        this.name = newName;
        this.protoType = ProtoType.get(this.protoType.enclosingTypeOrPackage(), newName);
    }

    @Override
    public Location location() {
        return this.location;
    }

    @Override
    public ProtoType type() {
        return this.protoType;
    }

    @Override
    public String documentation() {
        return this.documentation;
    }

    @Override
    public List<Type> nestedTypes() {
        return this.nestedTypes;
    }

    @Override
    public Options options() {
        return this.options;
    }

    public void addField(Field f) {
        this.declaredFields.add(f);
    }

    public void setDeclaredFields(List<Field> newFields) {
        this.declaredFields = newFields;
    }

    public List<Field> fields() {
        ArrayList<Field> allFields = new ArrayList<Field>(this.declaredFields);
        allFields.addAll(this.extensionFields);
        return allFields;
    }

    public void removeDeclaredField(Field f) {
        this.declaredFields.remove(f);
    }

    public ImmutableList<Field> fieldsAndOneOfFields() {
        ImmutableList.Builder result = ImmutableList.builder();
        result.addAll(this.declaredFields);
        result.addAll(this.extensionFields);
        for (OneOf oneOf : this.oneOfs) {
            result.addAll(oneOf.fields());
        }
        return result.build();
    }

    public Field field(String name) {
        for (Field field : this.declaredFields) {
            if (!field.name().equals(name)) continue;
            return field;
        }
        for (OneOf oneOf : this.oneOfs) {
            for (Field field : oneOf.fields()) {
                if (!field.name().equals(name)) continue;
                return field;
            }
        }
        return null;
    }

    public Field extensionField(String qualifiedName) {
        for (Field field : this.extensionFields) {
            if (!field.qualifiedName().equals(qualifiedName)) continue;
            return field;
        }
        return null;
    }

    public Field field(int tag) {
        for (Field field : this.declaredFields) {
            if (field.tag() != tag) continue;
            return field;
        }
        for (Field field : this.extensionFields) {
            if (field.tag() != tag) continue;
            return field;
        }
        return null;
    }

    public List<OneOf> oneOfs() {
        return this.oneOfs;
    }

    public List<Extensions> extensions() {
        return this.extensionsList;
    }

    Map<String, Field> extensionFieldsMap() {
        LinkedHashMap<String, Field> extensionsForType = new LinkedHashMap<String, Field>();
        for (Field field : this.extensionFields) {
            extensionsForType.put(field.qualifiedName(), field);
        }
        return extensionsForType;
    }

    void addExtensionFields(List<Field> fields) {
        this.extensionFields.addAll(fields);
    }

    @Override
    void link(Linker linker) {
        linker = linker.withContext(this);
        for (Field field : this.declaredFields) {
            field.link(linker);
        }
        for (Field field : this.extensionFields) {
            field.link(linker);
        }
        for (OneOf oneOf : this.oneOfs) {
            oneOf.link(linker);
        }
        for (Type type : this.nestedTypes) {
            type.link(linker);
        }
    }

    @Override
    void linkOptions(Linker linker) {
        linker = linker.withContext(this);
        for (Type type : this.nestedTypes) {
            type.linkOptions(linker);
        }
        for (Field field : this.declaredFields) {
            field.linkOptions(linker);
        }
        for (Field field : this.extensionFields) {
            field.linkOptions(linker);
        }
        for (OneOf oneOf : this.oneOfs) {
            oneOf.linkOptions(linker);
        }
        this.options.link(linker);
    }

    @Override
    void validate(Linker linker) {
        linker = linker.withContext(this);
        linker.validateFields((Iterable<Field>)this.fieldsAndOneOfFields(), this.reserveds);
        linker.validateEnumConstantNameUniqueness(this.nestedTypes);
        for (Field field : this.fieldsAndOneOfFields()) {
            field.validate(linker);
        }
        for (Type type : this.nestedTypes) {
            type.validate(linker);
        }
        for (Extensions extensions : this.extensionsList) {
            extensions.validate(linker);
        }
    }

    @Override
    Type retainAll(Schema schema, MarkSet markSet) {
        ImmutableList.Builder retainedNestedTypesBuilder = ImmutableList.builder();
        for (Type nestedType : this.nestedTypes) {
            Type retainedNestedType = nestedType.retainAll(schema, markSet);
            if (retainedNestedType == null) continue;
            retainedNestedTypesBuilder.add((Object)retainedNestedType);
        }
        ImmutableList retainedNestedTypes = retainedNestedTypesBuilder.build();
        if (!markSet.contains(this.protoType)) {
            if (retainedNestedTypes.isEmpty()) {
                return null;
            }
            return new EnclosingType(this.location, this.protoType, this.documentation, (List<? extends Type>)retainedNestedTypes);
        }
        ImmutableList.Builder retainedOneOfsBuilder = ImmutableList.builder();
        for (OneOf oneOf : this.oneOfs) {
            OneOf retainedOneOf = oneOf.retainAll(schema, markSet, this.protoType);
            if (retainedOneOf == null) continue;
            retainedOneOfsBuilder.add((Object)retainedOneOf);
        }
        ImmutableList retainedOneOfs = retainedOneOfsBuilder.build();
        return new MessageType(this.protoType, this.location, this.documentation, this.name, (List<Field>)Field.retainAll(schema, markSet, this.protoType, this.declaredFields), (List<Field>)Field.retainAll(schema, markSet, this.protoType, this.extensionFields), (List<OneOf>)retainedOneOfs, (List<Type>)retainedNestedTypes, this.extensionsList, this.reserveds, this.options.retainAll(schema, markSet));
    }

    static MessageType fromElement(String packageName, ProtoType protoType, MessageElement messageElement) {
        if (!messageElement.getGroups().isEmpty()) {
            GroupElement group = messageElement.getGroups().get(0);
            throw new IllegalStateException(group.getLocation() + ": 'group' is not supported");
        }
        List<Field> declaredFields = Field.fromElements(packageName, messageElement.getFields(), false);
        ArrayList<Field> extensionFields = new ArrayList<Field>();
        ImmutableList<OneOf> oneOfs = OneOf.fromElements(packageName, messageElement.getOneOfs(), false);
        ImmutableList.Builder nestedTypes = ImmutableList.builder();
        for (TypeElement nestedType : messageElement.getNestedTypes()) {
            nestedTypes.add((Object)Type.get(packageName, protoType.nestedType(nestedType.getName()), nestedType));
        }
        List<Extensions> extensionsList = Extensions.fromElements(messageElement.getExtensions());
        List<Reserved> reserveds = Reserved.fromElements(messageElement.getReserveds());
        Options options = new Options(Options.MESSAGE_OPTIONS, messageElement.getOptions());
        return new MessageType(protoType, messageElement.getLocation(), messageElement.getDocumentation(), messageElement.getName(), declaredFields, (List<Field>)extensionFields, (List<OneOf>)oneOfs, (List<Type>)nestedTypes.build(), extensionsList, reserveds, options);
    }

    MessageElement toElement() {
        return new MessageElement(this.location, this.name, this.documentation, (List<? extends TypeElement>)Type.toElements(this.nestedTypes), this.options.toElements(), Reserved.toElements(this.reserveds), (List<FieldElement>)Field.toElements(this.declaredFields), (List<OneOfElement>)OneOf.toElements(this.oneOfs), Extensions.toElements(this.extensionsList), Collections.emptyList());
    }

    public void updateDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void removeOneOf(OneOf oneOfToRemove) {
        this.oneOfs.remove(oneOfToRemove);
    }
}

