/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoMember;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.FieldElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class Field {
    static final ProtoMember DEPRECATED = ProtoMember.get(Options.FIELD_OPTIONS, "deprecated");
    static final ProtoMember PACKED = ProtoMember.get(Options.FIELD_OPTIONS, "packed");
    private String packageName;
    private final Location location;
    private Label label;
    private String name;
    private final String documentation;
    private int tag;
    private final String defaultValue;
    private String elementType;
    private final boolean extension;
    private final Options options;
    private ProtoType type;
    private Boolean deprecated;
    private Boolean packed;
    private boolean redacted;
    private boolean fromAttribute = false;
    private boolean fromElement = true;

    public boolean isFromAttribute() {
        return this.fromAttribute;
    }

    public void setFromAttribute(boolean fromAttribute) {
        this.fromAttribute = fromAttribute;
    }

    public boolean isFromElement() {
        return this.fromElement;
    }

    public void setFromElement(boolean fromElement) {
        this.fromElement = fromElement;
    }

    public Field(String packageName, Location location, Label label, String name, String documentation, int tag, String defaultValue, String elementType, Options options, boolean extension, boolean fromElement) {
        this.packageName = packageName;
        this.location = location;
        this.label = label;
        this.name = name;
        this.documentation = documentation;
        this.tag = tag;
        this.defaultValue = defaultValue;
        this.elementType = elementType;
        this.extension = extension;
        this.options = options;
        this.fromElement = fromElement;
    }

    public Field(String packageName, Location location, Label label, String name, String documentation, int tag, String elementType, Options options, boolean fromElement) {
        this.packageName = packageName;
        this.location = location;
        this.label = label;
        this.name = name;
        this.documentation = documentation;
        this.tag = tag;
        this.defaultValue = null;
        this.elementType = elementType;
        this.extension = false;
        this.options = options;
        this.fromElement = fromElement;
    }

    static List<Field> fromElements(String packageName, List<FieldElement> fieldElements, boolean extension) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (FieldElement field : fieldElements) {
            fields.add(new Field(packageName, field.getLocation(), field.getLabel(), field.getName(), field.getDocumentation(), field.getTag(), field.getDefaultValue(), field.getType(), new Options(Options.FIELD_OPTIONS, field.getOptions()), extension, false));
        }
        return fields;
    }

    static ImmutableList<FieldElement> toElements(List<Field> fields) {
        ImmutableList.Builder elements = new ImmutableList.Builder();
        for (Field field : fields) {
            elements.add((Object)new FieldElement(field.location, field.label, field.elementType, field.name, field.defaultValue, field.tag, field.documentation, field.options.toElements()));
        }
        return elements.build();
    }

    public Location location() {
        return this.location;
    }

    public String packageName() {
        return this.packageName;
    }

    public void clearPackageName() {
        this.packageName = null;
    }

    public Label label() {
        return this.label;
    }

    public boolean isRepeated() {
        return this.label() == Label.REPEATED;
    }

    public boolean isOptional() {
        return this.label() == Label.OPTIONAL;
    }

    public boolean isRequired() {
        return this.label() == Label.REQUIRED;
    }

    public ProtoType type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String qualifiedName() {
        return this.packageName != null ? this.packageName + '.' + this.name : this.name;
    }

    public int tag() {
        return this.tag;
    }

    public String documentation() {
        return this.documentation;
    }

    public Options options() {
        return this.options;
    }

    public boolean isDeprecated() {
        return this.deprecated != null && this.deprecated != false;
    }

    public boolean isPacked() {
        return this.packed != null && this.packed != false;
    }

    public boolean isRedacted() {
        return this.redacted;
    }

    public String getDefault() {
        return this.defaultValue;
    }

    private boolean isPackable(Linker linker, ProtoType type) {
        return !type.equals(ProtoType.STRING) && !type.equals(ProtoType.BYTES) && !(linker.get(type) instanceof MessageType);
    }

    public boolean isExtension() {
        return this.extension;
    }

    void link(Linker linker) {
        linker = linker.withContext(this);
        this.type = linker.resolveType(this.elementType);
    }

    void linkOptions(Linker linker) {
        linker = linker.withContext(this);
        this.options.link(linker);
        this.deprecated = (Boolean)this.options().get(DEPRECATED);
        this.packed = (Boolean)this.options().get(PACKED);
        this.redacted = this.options().optionMatches(".*\\.redacted", "true");
    }

    void validate(Linker linker) {
        linker = linker.withContext(this);
        if (this.isPacked() && !this.isPackable(linker, this.type)) {
            linker.addError("packed=true not permitted on %s", this.type);
        }
        if (this.extension && this.isRequired()) {
            linker.addError("extension fields cannot be required", this.type);
        }
        linker.validateImport(this.location(), this.type);
    }

    Field retainAll(Schema schema, MarkSet markSet) {
        if (this.type.isMap() && !markSet.contains(this.type.valueType())) {
            return null;
        }
        if (!markSet.contains(this.type)) {
            return null;
        }
        Field result = new Field(this.packageName, this.location, this.label, this.name, this.documentation, this.tag, this.defaultValue, this.elementType, this.options.retainAll(schema, markSet), this.extension, this.fromElement);
        result.type = this.type;
        result.deprecated = this.deprecated;
        result.packed = this.packed;
        result.redacted = this.redacted;
        return result;
    }

    static ImmutableList<Field> retainAll(Schema schema, MarkSet markSet, ProtoType enclosingType, Collection<Field> fields) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Field field : fields) {
            Field retainedField = field.retainAll(schema, markSet);
            if (retainedField == null || !markSet.contains(ProtoMember.get(enclosingType, field.name()))) continue;
            result.add((Object)retainedField);
        }
        return result.build();
    }

    public String toString() {
        return "Field [packageName=" + this.packageName + ", name=" + this.name + ", tag=" + this.tag + ", elementType=" + this.elementType + "]";
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public void updateTag(int updatedTag) {
        this.tag = updatedTag;
    }

    public void updateElementType(String newFieldType) {
        this.elementType = newFieldType;
    }

    public void updatePackageName(String newPackageName) {
        this.packageName = newPackageName;
    }

    public void updateName(String newFieldName) {
        this.name = newFieldName;
    }

    public String getElementType() {
        return this.elementType;
    }

    public static enum Label {
        OPTIONAL,
        REQUIRED,
        REPEATED,
        ONE_OF;

    }
}

