/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MessageType;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Type;
import com.squareup.wire.schema.internal.parser.ExtendElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import java.util.List;

public final class Extend {
    private final Location location;
    private final String documentation;
    private final String name;
    private final List<Field> fields;
    private ProtoType protoType;

    public Extend(Location location, String documentation, String name, List<Field> fields) {
        this.location = location;
        this.documentation = documentation;
        this.name = name;
        this.fields = fields;
    }

    static ImmutableList<Extend> fromElements(String packageName, List<ExtendElement> extendElements) {
        ImmutableList.Builder extendBuilder = new ImmutableList.Builder();
        for (ExtendElement extendElement : extendElements) {
            extendBuilder.add((Object)new Extend(extendElement.getLocation(), extendElement.getDocumentation(), extendElement.getName(), Field.fromElements(packageName, extendElement.getFields(), true)));
        }
        return extendBuilder.build();
    }

    static ImmutableList<ExtendElement> toElements(List<Extend> extendList) {
        ImmutableList.Builder elements = new ImmutableList.Builder();
        for (Extend extend : extendList) {
            elements.add((Object)new ExtendElement(extend.location, extend.name, extend.documentation, (List<FieldElement>)Field.toElements(extend.fields)));
        }
        return elements.build();
    }

    public Location location() {
        return this.location;
    }

    public ProtoType type() {
        return this.protoType;
    }

    public String documentation() {
        return this.documentation;
    }

    public List<Field> fields() {
        return this.fields;
    }

    void link(Linker linker) {
        linker = linker.withContext(this);
        this.protoType = linker.resolveMessageType(this.name);
        Type type = linker.get(this.protoType);
        if (type != null) {
            ((MessageType)type).addExtensionFields(this.fields);
        }
    }

    void validate(Linker linker) {
        linker = linker.withContext(this);
        linker.validateImport(this.location(), this.type());
    }
}

