/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.RpcElement;
import java.util.List;

public final class Rpc {
    private final Location location;
    private final String name;
    private final String documentation;
    private final String requestTypeElement;
    private final String responseTypeElement;
    private final Options options;
    private ProtoType requestType;
    private ProtoType responseType;
    private final boolean requestStreaming;
    private final boolean responseStreaming;

    private Rpc(Location location, String name, String documentation, String requestType, String responseType, boolean requestStreaming, boolean responseStreaming, Options options) {
        this.location = location;
        this.name = name;
        this.documentation = documentation;
        this.requestTypeElement = requestType;
        this.responseTypeElement = responseType;
        this.requestStreaming = requestStreaming;
        this.responseStreaming = responseStreaming;
        this.options = options;
    }

    public Location location() {
        return this.location;
    }

    public String name() {
        return this.name;
    }

    public String documentation() {
        return this.documentation;
    }

    public ProtoType requestType() {
        return this.requestType;
    }

    public ProtoType responseType() {
        return this.responseType;
    }

    public boolean requestStreaming() {
        return this.requestStreaming;
    }

    public boolean responseStreaming() {
        return this.responseStreaming;
    }

    public Options options() {
        return this.options;
    }

    void link(Linker linker) {
        linker = linker.withContext(this);
        this.requestType = linker.resolveMessageType(this.requestTypeElement);
        this.responseType = linker.resolveMessageType(this.responseTypeElement);
    }

    void linkOptions(Linker linker) {
        linker = linker.withContext(this);
        this.options.link(linker);
    }

    void validate(Linker linker) {
        linker = linker.withContext(this);
        linker.validateImport(this.location(), this.requestType);
        linker.validateImport(this.location(), this.responseType);
    }

    Rpc retainAll(Schema schema, MarkSet markSet) {
        if (!markSet.contains(this.requestType) || !markSet.contains(this.responseType)) {
            return null;
        }
        Rpc result = new Rpc(this.location, this.name, this.documentation, this.requestTypeElement, this.responseTypeElement, this.requestStreaming, this.responseStreaming, this.options.retainAll(schema, markSet));
        result.requestType = this.requestType;
        result.responseType = this.responseType;
        return result;
    }

    static ImmutableList<Rpc> fromElements(List<RpcElement> elements) {
        ImmutableList.Builder rpcs = new ImmutableList.Builder();
        for (RpcElement rpcElement : elements) {
            rpcs.add((Object)new Rpc(rpcElement.getLocation(), rpcElement.getName(), rpcElement.getDocumentation(), rpcElement.getRequestType(), rpcElement.getResponseType(), rpcElement.getRequestStreaming(), rpcElement.getResponseStreaming(), new Options(Options.METHOD_OPTIONS, rpcElement.getOptions())));
        }
        return rpcs.build();
    }

    static ImmutableList<RpcElement> toElements(ImmutableList<Rpc> rpcs) {
        ImmutableList.Builder elements = new ImmutableList.Builder();
        for (Rpc rpc : rpcs) {
            elements.add((Object)new RpcElement(rpc.location, rpc.name, rpc.documentation, rpc.requestTypeElement, rpc.responseTypeElement, rpc.requestStreaming, rpc.responseStreaming, rpc.options.toElements()));
        }
        return elements.build();
    }
}

