/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.wire.schema;

import com.google.common.collect.ImmutableList;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Linker;
import com.squareup.wire.schema.MarkSet;
import com.squareup.wire.schema.Options;
import com.squareup.wire.schema.ProtoType;
import com.squareup.wire.schema.Schema;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.GroupElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import java.util.Collections;
import java.util.List;

public final class OneOf {
    private final String name;
    private String documentation;
    private final List<Field> fields;
    private final Options options;

    public OneOf(String name, String documentation, List<Field> fields, Options options) {
        this.name = name;
        this.documentation = documentation;
        this.fields = fields;
        this.options = options;
    }

    public String name() {
        return this.name;
    }

    public String documentation() {
        return this.documentation;
    }

    public List<Field> fields() {
        return this.fields;
    }

    public Options options() {
        return this.options;
    }

    void link(Linker linker) {
        for (Field field : this.fields) {
            field.link(linker);
        }
    }

    void linkOptions(Linker linker) {
        this.options.link(linker);
        for (Field field : this.fields) {
            field.linkOptions(linker);
        }
    }

    OneOf retainAll(Schema schema, MarkSet markSet, ProtoType enclosingType) {
        ImmutableList<Field> retainedFields = Field.retainAll(schema, markSet, enclosingType, this.fields);
        if (retainedFields.isEmpty()) {
            return null;
        }
        return new OneOf(this.name, this.documentation, (List<Field>)retainedFields, this.options.retainAll(schema, markSet));
    }

    static ImmutableList<OneOf> fromElements(String packageName, List<OneOfElement> elements, boolean extension) {
        ImmutableList.Builder oneOfs = ImmutableList.builder();
        for (OneOfElement oneOf : elements) {
            if (!oneOf.getGroups().isEmpty()) {
                GroupElement group = oneOf.getGroups().get(0);
                throw new IllegalStateException(String.valueOf(group.getLocation()) + ": 'group' is not supported");
            }
            oneOfs.add((Object)new OneOf(oneOf.getName(), oneOf.getDocumentation(), Field.fromElements(packageName, oneOf.getFields(), extension), new Options(Options.ONE_OF_OPTIONS, oneOf.getOptions())));
        }
        return oneOfs.build();
    }

    static ImmutableList<OneOfElement> toElements(List<OneOf> oneOfs) {
        ImmutableList.Builder elements = new ImmutableList.Builder();
        for (OneOf oneOf : oneOfs) {
            elements.add((Object)new OneOfElement(oneOf.name, oneOf.documentation, (List<FieldElement>)Field.toElements(oneOf.fields), Collections.emptyList(), Collections.emptyList()));
        }
        return elements.build();
    }

    public void updateDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String toString() {
        return "OneOf [name='" + this.name + "', documentation='" + this.documentation + "', fields=" + String.valueOf(this.fields) + "]";
    }

    public void addField(Field newField) {
        this.fields.add(newField);
    }
}

