/*
 * Copyright 2016-2018 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.domain.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;

/**
 * Annotation specifying g9 specific parameters for attributes.
 */
@Target({ElementType.FIELD})
public @interface G9Attribute {
	// DB Properties
	boolean isPersistent() default false;
	PrimaryKeyCreator primaryKeyCreator() default PrimaryKeyCreator.Database;
	int dbLength() default 0;
	int precision() default 0;
	int scale() default 0;
	String constraints() default "";
	String defaultValue() default "";
	String columnName() default "";
	boolean isInsertProhibited() default false;
	boolean isUpdateProhibited() default false;
	boolean isPrimaryKey() default false;
	boolean isDefaultDomainKey() default false;
	boolean isUnique() default false;
	boolean isNotNull() default false;
	boolean isIndex() default false;
	// UI Properties
	String title() default "";
	String displayRule() default "";
	int fieldLength() default 0;
	boolean isBlankWhenZero() default false;
	Justification inputJustification() default Justification.Left;
	Justification outputJustification() default Justification.Left;
	String validator() default "";
	Class<?> converter() default void.class;
}
