/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.domain;

import java.util.List;

import no.g9.support.G9Enumerator;

/**
 * Methods for converting between enum value and enum text for domain classes
 * inheriting from G9Enumerator. You may also retrieve a list of all enum
 * values for a given enumerator.
 */
public interface G9Enums {
    
    /** The no value constant */
    int NO_VALUE = Integer.MIN_VALUE; 

    /**
     * Returns the int value for the enumeration from class 'name', with a given
     * title. Used in autogenerated code - in your code, please use the function
     * toValue.
     * 
     * @param name The name of the enumeration.
     * @param title The title of the enum to convert as defined in Rose.
     * @return The int value (currentValue) of the enumerator.
     */
    public int toValue(String name, String title);

    /**
     * Converts the enumeration value to its title for the enumeration from the
     * class name. Used in autogenerated code - in your code, please use the
     * function toName.
     * 
     * @param name The name of the enumeration.
     * @param value The currentValue of the enumeration.
     * @return The title, as defined in Rose.
     */
    public String toName(String name, int value);

    /**
     * Assigns value to enum based on in object owner.
     * 
     * @param owner The object to set.
     * @param attribute The attribute to set value for.
     * @param enumObject The enum object to set.
     */
    public void enumAssign(Object owner, String attribute, Object enumObject);

    /**
     * Returns the list of all enumeration values for a given enumeration.
     * 
     * @param enumName The name of the enumeration (class)
     * @return List of g9 enumeration objects with currentValue set.
     */
    public List<G9Enumerator> allEnums(String enumName);
    
}