/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.exception;

import no.g9.support.convert.SimpleDateConverter;

/**
 * SimpleDateConverterException is an exception thrown by
 * {@link SimpleDateConverter} to indicate that the request conversion cannot
 * be performed.
 * 
 */
public class SimpleDateConverterException extends RuntimeException {

    private Throwable cause= null;
    
    /**
     * Construct a new exception with no detail message or root cause.
     */
    public SimpleDateConverterException() {
       super(); 
    }
    
    /**
     * 
     * Construct a new exception with the specified detail message and
     * no root cause.
     *
     * @param message The detail message for this exception
     */
    public SimpleDateConverterException(String message) {
        super(message);
    }
    
    /**
     * Construct a new exception with the specified root cause.  The detail
     * message will be set to <code>(cause == null ? null :
     * cause.toString()</code>
     *
     * @param cause The root cause for this exception
     */
    public SimpleDateConverterException(Throwable cause) {
        super(cause == null ? null : cause.toString());
        this.cause = cause;
    }
    
    /**
     * Construct a new exception with the specified detail message and
     * root cause.
     *
     * @param message The detail message for this exception
     * @param cause The root cause for this exception
     */
    public SimpleDateConverterException(String message, Throwable cause) {
        super(message);
        this.cause= cause;
    }

    @Override
    public synchronized Throwable getCause() {
        return this.cause;
    }

}
