/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.message;

/**
 * Message numbers for g9 runtime.
 *
 */
public interface CRuntimeMsg {

    /** Message: Unhandled exception: */
    public static final String UNHANDLED_EXCEPTION = "-1000";

    /* --- Property messages (-1000 series) ----------------------- */
    /** Message: Property not found (unknown). */
    public static final String PROPERTY_UNKNOWN = "-1001";

    /* --- IO messages (-1100 series) ----------------------------- */
    /** Message: File not found. */
    public static final String IO_FILE_NOT_FOUND = "-1101";

    /** Message: Error reading from file. */
    public static final String IO_FILE_READ_ERROR = "-1102";

    /* --- DB and ORM messages (-1200 series) --------------------- */
    /** Message: DB or ORM error. */
    public static final String DB_ORM_ERROR = "-1201";

    /** Message: DB query parameter error. */
    public static final String DB_QUERY_PARAM_ERROR = "-1202";

    /* --- SM (Server Manager) messages (-1300 series) ------------ */
    /** Message: Neither Delete nor Disconnect is allowed. */
    public static final String SM_DELETE_NOT_ALLOWED = "-1301";

    /** Message: No key defined in object selection. */
    public static final String SM_NO_KEY_DEFINED = "-1302";

    /** Message: Update of nonexisting object. */
    public static final String SM_UPDATE_ON_NONEXISTING = "-1303";

    /** Message: Insert of already existing object. */
    public static final String SM_INSERT_ON_EXISTING = "-1304";

    /** Message: Find is not an allowed action. */
    public static final String SM_FIND_NOT_ALLOWED = "-1305";

    /** Message: Identify of nonexisting object. */
    public static final String SM_IDENTIFY_ON_NONEXISTING = "-1306";

    /** Message: Identify of nonexisting parent object. */
    public static final String SM_NONEXISTING_PARENT = "-1307";

    /** Message: Object does not have a related object. */
    public static final String SM_MISSING_RELATED_OBJECT = "-1308";

    /** Message: Object was updated by another user. */
    public static final String SM_UPDATED_BY_ANOTHER_USER = "-1309";

    /** Message: Object not updated, missing value for optimistic locking. */
    public static final String SM_NO_LOCKFLAG_VALUE = "-1310";

    /** Message: Unable to create intance of role manager */
    public static final String SM_UNABLE_TO_CREATE_ROLE_INSTANCE = "-1311";

    /** Message: Unable to create intance of role manager */
    public static final String SM_UNKNOWN_SERVICE_ACTION = "-1312";

    /* --- FL (File Launcher) messages (-1400 series) ------------ */
    /** Message: Unable to open a local file in default application */
    public static final String FL_OPEN_LOCAL_FILE_ERROR = "-1401";

    /** Message: Unable to open a URL in default browser */
    public static final String FL_OPEN_REMOTE_URL_ERROR = "-1402";

    /* --- CF (Client Framework) messages (-1500 series) ------------ */
    /** Message: Expected list block not present */
    public static final String CF_NO_LISTBLOCK_ERROR = "-1501";

    /** Message: Listblock role is missing */
    public static final String CF_NO_LISTBLOCKROLE = "-1502";

    /** Message: Listblock role is missing */
    public static final String CF_NO_ROOT_TARGET = "-1503";

    /** Message: Missing child role in path to target */
    public static final String CF_NO_TARGET = "-1504";

    /** Message: No objects found to insert in listblock */
    public static final String CF_NO_ASSOCIATION = "-1505";

    /** Message: Missing path from root node to target */
    public static final String CF_NO_PATH_ROOT_TO_TARGET = "-1506";

    /** Message: Encountered a more relation while building arguments to insert in listblock. */
    public static final String CF_MORE_RELATION_IN_LISTBLOCK = "-1507";

    /** Message: Illegal association  */
    public static final String CF_ILLEGAL_ASSOCIATION_TYPE = "-1508";

    /** Message: Unable to access field or method in a domain object (Reflection). */
    public static final String CF_UNABLE_TO_ACCESS_FIELD_OR_METHOD = "-1509";

    /** Message: Unable to create an instance of a domain object (Reflection). */
    public static final String CF_UNABLE_TO_CREATE_DOMAINOBJ_INSTANCE = "-1510";

    /** Message: Invalid calculated column width in a g9 table */
    public static final String CF_INVALID_COLUMN_WIDTH = "-1511";

    /** Message: Image file could not be located */
    public static final String CF_IMAGE_NOT_FOUND = "-1512";

    /** Message: Unable to select an dialog */
    public static final String CF_UNABLE_TO_SELECT_DIALOG = "-1513";

    /** Message: Unable to parse new value for field */
    public static final String CF_DOCUMENT_PARSEEXCEPTION = "-1514";

    /** Message: Unable to parse date */
    public static final String CF_DATE_PARSE_MSG = "-1515";

    /** Message: Failed to load look and feel */
    public static final String CF_LOOK_AND_FEEL = "-1516";

    /** Message: Caught exception */
    public static final String CF_CAUGHT = "-1517";

    /** Message: No such column */
    public static final String NO_SUCH_COLUMN = "-1518";

    /** Message: Could not close all dialogs because of unhandled exception. Exit application anyway? */
    public static final String COULD_NOT_CLOSE_ALL = "-1519";

    /** Message: No such role */
    public static final String CF_NO_SUCH_ROLE = "-1520";

    /** Message: No such attribute */
    public static final String CF_NO_SUCH_ATTRIBUTE = "-1521";

    /** Message: No such icon */
    public static final String CF_NO_SUCH_ICON = "-1522";

    /** Field validation failed */
    public static final String CF_VALIDATION_FAILED = "-1523";

    /** Failed to execute action */
    public static final String CF_FAILED_TO_EXECUTE_ACTION = "-1524";

    /** Mandatory field failed validation */
    public static final String CF_MANDATORY_FAILED = "-1525";

    /** Framework conversion to view model failed */
    public static final String CF_FRAMEWORK_CONVERSION_FAILED = "-1526";

    /** Field validation failed */
    public static final String CF_FIELD_VALIDATION_FAILED = "-1527";

    /** Field validation failed */
    public static final String CF_VALIDATION_FAILED_MAIN = "-1528";

    /** Failed to get roles for */
    public static final String CF_GET_ROLES_FAILED = "-1529";

    /** &lt;1&gt; returned false. Aborting &lt;2&gt; &lt;3&gt; action */
    public static final String CF_ABORTING_ACTION = "-1530";

    /** Dialog-check ok. Continuing with &lt;1&gt; &lt;2&gt; action */
    public static final String CF_CONTINUING_ACTION = "-1531";

    /** Converting object selection to document */
    public static final String CF_CONVERT_TO_DOCUMENT = "-1532";

    /** Invoking print service for &lt;1&gt; */
    public static final String CF_INVOKING_PRINT = "-1533";


    /** Framework conversion to view model failed for field */
    public static final String CF_FRAMEWORK_FIELD_CONVERSION_FAILED = "-1534";

    /* --- CCC (Client CheckChanged) messages (-1600 series) ------------ */
    /**
     * Message: Displayed to the user if dialog contains changed data when
     * find action occurs
     */
    public final static String CC_CHECK_FIND_MSG = "-1601";

    /**
     * Message: Displayed to the user if dialog contains changed data when
     * close action occurs
     */
    public final static String CC_CHECK_CLOSE_MSG = "-1602";

    /**
     * Message: Displayed to the user if dialog contains changed data when
     * delete action occurs
     */
    public final static String CC_CHECK_DELETE_MSG = "-1603";

    /**
     * Message: Displayed to the user if dialog contains changed data when
     * clear action occurs
     */
    public final static String CC_CHECK_CLEAR_MSG = "-1604";

    /**
     * Message: Unsaved data will be lost! Select new row?
     */
    public final static String CC_CHECK_SELECTION_MSG = "-1605";

    /**
     * Message: Unsaved data will be lost! Unselect row?
     */
    public final static String CC_CHECK_UNSELECTION_MSG = "-1606";

    /**
     * Message displayed to user if dialog has changed before an invoke action.
     */
    public final static String CC_CHECK_INVOKE_MSG = "-1607";

    /**
     * Message displayed to user if dialog has changed before closing a dialog instance to open up another.
     */
    public final static String CC_CHECK_OPEN_MSG = "-1608";

    /* --- R (Reflection) messages (-1700 series) --- */

    /**
     * Message: Class not found
     */
    public final static String R_CLASS_NOT_FOUND = "-1701";

    /**
     * Message: Can't create class
     */
    public final static String R_CANT_CREATE_CLASS = "-1702";

    /* --- T (Thread) messages (-1800 series) --- */

    /**
     * Message: Thread interrupted.
     */
    public final static String CT_INTERRUPTED = "-1801";

    /**
     * Message"; Thread invocation target exception.
     */
    public final static String CT_INVOCATION_TARGET = "-1802";

    /* --- Client text messages (-1900 series) --- */
    /** Cut menu item title. */
    public final static String CM_TEXT_CUT = "-1901";
    /** Copy menu item title */
    public final static String CM_TEXT_COPY = "-1902";
    /** Paste menu item title */
    public final static String CM_TEXT_PASTE = "-1903";
    /** Select all menu item title */
    public final static String CM_TEXT_SELECTALL = "-1904";
    /** Tile menu itme title */
    public final static String CM_TEXT_TILE = "-1905";
    /** Cascade menu item title */
    public final static String CM_TEXT_CASCADE = "-1906";
    /** No button title */
    public final static String CM_TEXT_NO = "-1907";
    /** Yes button title */
    public final static String CM_TEXT_YES = "-1908";
    /** Cancle button title */
    public final static String CM_TEXT_CANCEL = "-1909";
    /** OK button title */
    public final static String CM_TEXT_OK = "-1910";
    /** Info message box title */
    public final static String CM_TEXT_INFO = "-1911";
    /** Ignore button title */
    public final static String CM_TEXT_IGNORE = "-1912";
    /** Retry button title */
    public final static String CM_TEXT_RETRY = "-1913";
    /** Abort button title */
    public final static String CM_TEXT_ABORT = "-1914";
    /** Unknown title */
    public final static String CM_TEXT_UNKNOWN = "-1915";

    /* --- Print messages  (-2000 series) --- */
    /** Error";OK";";Printing the report failed. */
    public static final String PM_PRINTING_REPORT_FAILED = "-2001";

    /** Error";OK";";Filling the report failed. */
    public static final String PM_FILLING_REPORT_FAILED = "-2002";

    /** Error";OK";";Neither a file name nor\nan output stream is given as input. */
    public static final String PM_MISSING_FILE_OR_STREAM = "-2003";

    /** Error";OK";";The export to PDF file failed. */
    public static final String PM_PDF_EXPORT_FAILED = "-2004";

    /** Error";OK";";Creating the export stream failed. */
    public static final String PM_EXPORT_STREAM_FAILED = "-2005";

    /** Error";OK";";The conversion to Document failed. */
    public static final String PM_CONVERSION_FAILED = "-2006";

    /** Debug";None";Timing";Report filled in &lt;1&gt; ms. */
    public static final String PM_FILLED_TIME = "-2007";

    /** Error";None";";Setting the printer service &lt;1&gt; failed. */
    public static final String PM_SETTING_PRINTER_SERVICE_FAILED = "-2008";

    /** Error";OK";";No printer with name &lt;1&gt; found.*/
    public static final String PM_NO_SUCH_PRINTER = "-2009";

    /** Error";OK";";Could not locate image resource: &lt;1&gt;. */
    public static final String PM_COULD_NOT_LOCATE_IMG = "-2010";

    /** Error";OK";";Invalid print context. */
    public static final String PM_INVALID_PRINT_CONTEXT = "-2011";

    /** Error";OK";";Failed to convert or validate. */
    public static final String CV_CONVERT_OR_VALIDATION_FAILED = "-2101";

    /** Error;OK;;Communication error when trying to send the message &lt;1&gt;. Status code: &lt;2&gt;, error description &lt;3&gt;. */
    public static final String COM_SENDING_FAILED = "-2201";
}
