/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.message;

import no.esito.util.BeanID;

/**
 * This interface is used to set up message dispatchers for the message system.
 * The setup process is as follows:
 * 1. The message dispatcher is created by spring.
 * 2. The <code>DispatcherContext</code> is set on the dispatcher.
 */
@BeanID("messageDispatcher")
public interface MessageDispatcherSetup extends MessageDispatcher {

	/**
	 * Setter for the message context.
	 * @param dispatcherContext The message context to be set.
	 */
	public void setDispatcherContext(DispatcherContext dispatcherContext);

}