/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.service;

import no.esito.util.BeanID;
import no.esito.util.G9PropertyName;
import no.g9.support.ClientContext;
import no.g9.support.FindData;
import no.g9.support.ObjectSelection;
import no.g9.service.enumerator.ENavigation;
import java.util.List;

/**
 * Service interface for generated Managers.
 */
@BeanID("jgrapeService")
@G9PropertyName("JGrapeService")
public interface JGrapeService {

    /**
     * @param objectSelection (missing javadoc)
     * @param ctx (missing javadoc)
     * @return (missing javadoc)
     */
    public Object find(ObjectSelection objectSelection, ClientContext ctx);

    /**
     * Find a domain object or projection based on the given <code>findData</code>.
     * 
     * Example (returns the number of Customers in the database):
     *      FindData fd = new FindData();
     *      fd.setFindMethod(EFindMethod.CRITERIA);
     *      fd.setDomainClass(Customer.class);
     *      fd.setCriteriaProjection(Projections.rowCount());
     *      Object result = Application.getServiceProxy().find(fd, ctx, dbMapping);
     * 
     * @param findData what to find, and how
     * @param ctx the <code>ClientContext</code> to be used
     * @param dbMapping the name of the g9 Database Mapping to be used,
     *                  <code>null</code> will use the default Session configuration
     * @return Object the first row in the result set
     */
    public Object find(FindData findData, ClientContext ctx, String dbMapping);

    /**
     * @param objectSelection (missing javadoc)
     * @param ctx (missing javadoc)
     * @return (missing javadoc)
     */
    public List<?> findAll(ObjectSelection objectSelection, ClientContext ctx);

    /**
     * Find domain objects or projections based on the given <code>findData</code>.
     * 
     * Example (returns the number of Customers in the database, grouped by zip code):
     *      FindData fd = new FindData();
     *      fd.setFindMethod(EFindMethod.CRITERIA);
     *      fd.setDomainClass(Customer.class);
     *      ProjectionList pl = Projections.projectionList();
     *      pl.add( Projections.rowCount() );
     *      pl.add( Projections.groupProperty("zip") );
     *      fd.setCriteriaProjection(pl);
     *      Object result = Application.getServiceProxy().findAll(fd, ctx, dbMapping);
     * 
     * @param findData what to find, and how
     * @param ctx the <code>ClientContext</code> to be used
     * @param dbMapping the name of the g9 Database Mapping to be used,
     *                  <code>null</code> will use the default Session configuration
     * @return List the result set
     */
    public List<?> findAll(FindData findData, ClientContext ctx, String dbMapping);

    /**
     * @param objectSelection (missing javadoc)
     * @param ctx (missing javadoc)
     * @return (missing javadoc)
     */
    public Object save(ObjectSelection objectSelection, ClientContext ctx);

    /**
     * @param objectSelection (missing javadoc)
     * @param ctx (missing javadoc)
     * @return (missing javadoc)
     */
    public Object insert(ObjectSelection objectSelection, ClientContext ctx);

    /**
     * @param objectSelection (missing javadoc)
     * @param ctx (missing javadoc)
     * @return (missing javadoc)
     */
    public Object update(ObjectSelection objectSelection, ClientContext ctx);

    /**
     * @param objectSelection (missing javadoc)
     * @param ctx (missing javadoc)
     * @return (missing javadoc)
     */
    public Object delete(ObjectSelection objectSelection, ClientContext ctx);

    /**
     * @param objectSelection (missing javadoc)
     * @param ctx (missing javadoc)
     * @return (missing javadoc)
     */
    public Object connect(ObjectSelection objectSelection, ClientContext ctx);

    /**
     * @param objectSelection (missing javadoc)
     * @param ctx (missing javadoc)
     * @return (missing javadoc)
     */
    public Object disconnect(ObjectSelection objectSelection, ClientContext ctx);

    /**
     * @param objectSelection (missing javadoc)
     * @param navigation (missing javadoc)
     * @param ctx (missing javadoc)
     * @return (missing javadoc)
     */
    public Object get(ObjectSelection objectSelection, ENavigation navigation,
            ClientContext ctx);
}
