/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support.castor;

import org.exolab.castor.mapping.AbstractFieldHandler;
import org.exolab.castor.mapping.FieldHandler;
import org.springframework.util.StringUtils;

/**
 * A {@link FieldHandler} used to generate XML identificators used for a given domain class being marshalled.
 * <p>
 * <strong>WARNING:</strong> Although this class is public, it should not be treated as part of the public API, as it
 * might change in incompatible ways between releases (even patches).
 * 
 * <p>
 * <strong>NOTE:</strong>The id generated is based on the class name and its implementation of {@link Object#hashCode() }
 * 
 */
@SuppressWarnings("rawtypes")
public class XmlIdFieldHandler extends AbstractFieldHandler {

    @Override
    public Object getValue(Object object) throws IllegalStateException {
        if (object == null)
            return null;
        return createIdPrefixFrom(object) + "_" + object.getClass().getSimpleName().toLowerCase() + "_"
                        + Integer.toHexString(System.identityHashCode(object));
    }

    @Override
    public Object newInstance(Object parent) throws IllegalStateException {
        // do nothing
        return null;
    }

    @Override
    public Object newInstance(Object parent, Object[] args) throws IllegalStateException {
        // do nothing
        return null;
    }

    @Override
    public void resetValue(Object object) throws IllegalStateException, IllegalArgumentException {
        // do nothing
    }

    @Override
    public void setValue(Object object, Object value) throws IllegalStateException, IllegalArgumentException {
        // do nothing

    }

    /**
     * 
     * @param object
     *            The object to extract name from
     * @return the las items in the package name
     */
    static String createIdPrefixFrom(Object object) {
        if (object == null) {
            return "";
        }
        String packageName = object.getClass().getPackage().getName();
        if (!StringUtils.hasText(packageName)) {
            return "";
        }
        String[] packages = StringUtils.tokenizeToStringArray(packageName, ".");
        return packages[packages.length - 1];
    }

}
