/*
 * Decompiled with CFR 0.152.
 */
package no.esito.util;

import java.text.ParseException;
import no.g9.support.FormatHelper;
import no.g9.support.Numeric;

public class NumberFormat {
    private int datatype;
    private String displayRule;

    public NumberFormat(int datatype, String displayRule) {
        this.datatype = datatype;
        this.displayRule = displayRule;
    }

    public String format(String format, Object number, boolean internalFormat) {
        String inputFormat = this.getInputFormat();
        int intLength = this.getIntLength();
        int decimalLength = this.getDecimalLength();
        int sign = FormatHelper.getSign(this.displayRule);
        int maxLength = inputFormat.length();
        int sign1 = sign;
        if (format.equals(inputFormat)) {
            if (sign1 == -1) {
                sign1 = -2;
            }
            if (sign1 == 1) {
                sign1 = 2;
            }
        }
        StringBuffer res = new StringBuffer();
        if (number != null) {
            String bStr = number.toString();
            int intPos = 0;
            boolean negative = false;
            if (bStr.length() > 0) {
                int dot;
                int noDigits;
                if (bStr.length() > 0 && bStr.charAt(intPos) == '-') {
                    negative = true;
                    ++intPos;
                }
                if ((noDigits = bStr.indexOf(dot = 46)) < 0) {
                    noDigits = bStr.length();
                }
                if ((noDigits -= intPos) > intLength || negative && sign1 == 0) {
                    for (noDigits = 0; noDigits < maxLength; ++noDigits) {
                        res.append('#');
                    }
                    return res.toString();
                }
                int dotPos = format.indexOf(46);
                int signPos = this.addInt(dotPos < 0 ? format : format.substring(0, dotPos + 1), sign1, internalFormat, noDigits < 0 ? "0" : bStr.substring(intPos, noDigits + intPos), intLength, res);
                if (dotPos >= 0) {
                    intPos = bStr.indexOf(dot) + 1;
                    if (intPos > 0 && intPos <= bStr.length()) {
                        noDigits = bStr.length() - intPos;
                        bStr = bStr.substring(intPos);
                        while (decimalLength > noDigits) {
                            bStr = bStr.concat("0");
                            ++noDigits;
                        }
                    } else {
                        bStr = "";
                    }
                    int tmp = this.addInt(format.substring(dotPos + 1), sign1, internalFormat, bStr, decimalLength, res);
                    if (signPos == -1) {
                        signPos = tmp;
                    }
                }
                if (signPos >= 0 && sign1 != 0) {
                    if (negative) {
                        res.insert(signPos, '-');
                    } else if (sign1 == 1 || sign1 == 2) {
                        res.insert(signPos, '+');
                    } else if (sign1 == -1) {
                        res.insert(signPos, ' ');
                    }
                }
                if (format.equals(inputFormat) || format.charAt(0) == '#' || format.charAt(0) == '+' && sign1 != -1 && sign1 != 1) {
                    int i;
                    for (i = 0; i < res.length() && res.charAt(i) == ' '; ++i) {
                    }
                    if (i > 0) {
                        res.delete(0, i);
                    }
                    for (i = res.length() - 1; i >= 0 && res.charAt(i) == ' '; --i) {
                    }
                    if (++i >= 0) {
                        res.delete(i, res.length());
                    }
                }
            }
        }
        return res.toString();
    }

    public Object parse(String str, boolean internalFormat) throws ParseException {
        Number retVal = null;
        if (str != null && str.length() != 0) {
            char c;
            StringBuffer numBuffer;
            char decimalSeparator = internalFormat ? (char)'.' : (char)FormatHelper.getDecimalSeparator();
            StringBuffer decimalBuffer = numBuffer = new StringBuffer();
            for (int i = 0; i < str.length(); ++i) {
                char c2 = str.charAt(i);
                if (c2 == '-' && internalFormat && i != 0) {
                    throw new ParseException("Illegal character", i);
                }
                if (Character.isDigit(c2) || c2 == '-') {
                    decimalBuffer.append(c2);
                    continue;
                }
                if (c2 == decimalSeparator) {
                    if (this.datatype == 1 || this.datatype == 2 || this.datatype == 15) {
                        if (internalFormat) {
                            throw new ParseException("Illegal character", i);
                        }
                        decimalBuffer = new StringBuffer();
                        continue;
                    }
                    decimalBuffer.append('.');
                    continue;
                }
                if (!internalFormat) continue;
                throw new ParseException("Illegal character", i);
            }
            int round = 0;
            if (decimalBuffer != numBuffer && decimalBuffer.length() > 0 && Character.isDigit(c = decimalBuffer.charAt(0)) && Character.digit(c, 10) >= 5) {
                round = numBuffer.length() > 0 && numBuffer.charAt(0) == '-' ? -1 : 1;
            }
            try {
                switch (this.datatype) {
                    case 1: {
                        retVal = Short.valueOf(numBuffer.toString());
                        if (round == 0) break;
                        short sh = retVal;
                        retVal = (short)(sh + round);
                        break;
                    }
                    case 2: {
                        retVal = Integer.valueOf(numBuffer.toString());
                        if (round == 0) break;
                        int in = (Integer)retVal;
                        retVal = in + round;
                        break;
                    }
                    case 15: {
                        retVal = Long.valueOf(numBuffer.toString());
                        if (round == 0) break;
                        long in = (Long)retVal;
                        retVal = in + (long)round;
                        break;
                    }
                    case 3: {
                        retVal = new Numeric(numBuffer.toString(), this.getDecimalLength());
                        break;
                    }
                    case 4: {
                        retVal = new Float(numBuffer.toString());
                        break;
                    }
                    case 5: {
                        retVal = new Double(numBuffer.toString());
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage(), 0);
            }
        }
        return retVal;
    }

    public static boolean isZero(Object value) {
        boolean result = true;
        if (value != null) {
            if (value instanceof Numeric) {
                result = ((Numeric)value).compareTo(new Numeric(0L, ((Numeric)value).getScale())) == 0;
            } else if (value instanceof Short) {
                result = ((Short)value).compareTo((short)0) == 0;
            } else if (value instanceof Integer) {
                result = ((Integer)value).compareTo(0) == 0;
            } else if (value instanceof Long) {
                result = ((Long)value).compareTo(0L) == 0;
            } else if (value instanceof Float) {
                result = ((Float)value).compareTo(new Float(0.0)) == 0;
            } else if (value instanceof Double) {
                result = ((Double)value).compareTo(new Double(0.0)) == 0;
            }
        }
        return result;
    }

    private int addInt(String format, int sign1, boolean internalFormat, String number, int maxLength, StringBuffer buffer) {
        int signPos = -1;
        int resPos = 0;
        int intPos = 0;
        int formatPos = -1;
        int noDigits = number.length();
        for (formatPos = 0; formatPos < format.length(); ++formatPos) {
            char c = format.charAt(formatPos);
            switch (c) {
                case '+': {
                    signPos = resPos;
                    break;
                }
                case '#': 
                case '0': {
                    if (noDigits < maxLength) {
                        ++noDigits;
                        if (c == '0') {
                            buffer.append('0');
                            break;
                        }
                        buffer.append(' ');
                        if (signPos < 0 || sign1 != -2 && sign1 != 2) break;
                        signPos = resPos;
                        break;
                    }
                    buffer.append((char)(number.length() == 1 && c == '#' && number.charAt(0) == '0' ? 32 : number.charAt(intPos)));
                    ++intPos;
                    break;
                }
                case ',': {
                    buffer.append(FormatHelper.getGroupingSeparator());
                    break;
                }
                case '.': {
                    buffer.append(internalFormat ? (char)'.' : (char)FormatHelper.getDecimalSeparator());
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            ++resPos;
        }
        return signPos;
    }

    private String getInputFormat() {
        String outputFormat = FormatHelper.getNumericFormat(this.displayRule);
        return FormatHelper.getNumericInputFormat(outputFormat);
    }

    private int getDecimalLength() {
        int decimalLength = 0;
        String inputFormat = this.getInputFormat();
        if (inputFormat.indexOf(46) != -1) {
            decimalLength = Math.max(inputFormat.length() - this.getIntLength() - 1, 0);
        }
        return decimalLength;
    }

    private int getIntLength() {
        int sign;
        int intLength = this.getInputFormat().indexOf(46);
        if (intLength == -1) {
            intLength = this.getInputFormat().length();
        }
        if ((sign = FormatHelper.getSign(this.displayRule)) != 0) {
            --intLength;
        }
        return intLength;
    }
}

