/*
 * Decompiled with CFR 0.152.
 */
package no.g9.domain;

import java.util.HashMap;
import java.util.Map;
import no.g9.domain.DomainObjectProxy;
import no.g9.domain.G9Enums;
import no.g9.domain.G9Proxy;

public class DomainProxy {
    private Map<ProxyKey, DomainObjectProxy> proxiedObjects = new HashMap<ProxyKey, DomainObjectProxy>();
    private boolean useAccessMethods;
    private G9Enums enums;

    public DomainProxy(boolean useAccessMethods, G9Enums enums) {
        this.useAccessMethods = useAccessMethods;
        this.enums = enums;
    }

    public <T> DomainObjectProxy<T> getProxy(T o, String roleName) {
        ProxyKey key = new ProxyKey(o, roleName);
        G9Proxy<T> d = this.proxiedObjects.get(key);
        if (d == null) {
            d = new G9Proxy<T>(o, this.enums, this.useAccessMethods);
            this.proxiedObjects.put(key, d);
        }
        return d;
    }

    public <T> DomainObjectProxy<T> getNewProxy(T o, String roleName) {
        G9Proxy<T> g = new G9Proxy<T>(o, this.enums, this.useAccessMethods);
        this.proxiedObjects.put(new ProxyKey(o, roleName), g);
        return g;
    }

    public void removeProxy(DomainObjectProxy<?> proxy) {
        this.proxiedObjects.values().remove(proxy);
    }

    public void removeAllProxies() {
        this.proxiedObjects.clear();
    }

    private static class ProxyKey {
        private Object domainObject;
        private String roleName;

        public ProxyKey(Object domainObject, String roleName) {
            this.domainObject = domainObject;
            this.roleName = roleName;
        }

        public int hashCode() {
            return this.domainObject.hashCode() + this.roleName.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ProxyKey)) {
                return false;
            }
            ProxyKey tmp = (ProxyKey)o;
            return this.roleName.equals(tmp.roleName) && this.domainObject.equals(tmp.domainObject);
        }
    }
}

