/*
 * Decompiled with CFR 0.152.
 */
package no.g9.domain;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import no.esito.util.EnumUtil;
import no.g9.domain.DomainObjectProxy;
import no.g9.domain.DomainUtil;
import no.g9.domain.G9Enums;
import no.g9.exception.G9BaseException;
import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.support.G9Enumerator;
import no.g9.support.Numeric;
import no.g9.support.TypeTool;

public class G9Proxy<T>
implements DomainObjectProxy<T> {
    public static final byte ZERO_VALUE_BYTE = 0;
    public static final short ZERO_VALUE_SHORT = 0;
    public static final int ZERO_VALUE_INT = 0;
    public static final char ZERO_VALUE_CHAR = '\u0000';
    public static final long ZERO_VALUE_LONG = 0L;
    public static final float ZERO_VALUE_FLOAT = 0.0f;
    public static final double ZERO_VALUE_DOUBLE = 0.0;
    public static final boolean ZERO_VALUE_BOOLEAN = false;
    private Map<String, Stack<Object>> attributesActedOn;
    private T domainObject;
    private Class<T> domainClass;
    private boolean useAccessMethods;
    private G9Enums enums;

    public G9Proxy(T domainObject, G9Enums enums, boolean useAccessMethods) {
        this.domainObject = domainObject;
        this.domainClass = DomainUtil.getDomainClass(domainObject);
        this.useAccessMethods = useAccessMethods;
        this.enums = enums;
    }

    @Override
    public boolean isClean() {
        return this.attributesActedOn == null;
    }

    @Override
    public boolean isClean(String attributeName) {
        return this.isClean() || !this.attributesActedOn.containsKey(attributeName);
    }

    @Override
    public T getCleanVersionOfObject() {
        if (this.isClean()) {
            return this.domainObject;
        }
        G9Proxy<T> cleanProxy = new G9Proxy<T>(this.createClone(), this.enums, this.useAccessMethods);
        for (String attributeName : this.attributesActedOn.keySet()) {
            Object value = this.attributesActedOn.get(attributeName).firstElement();
            cleanProxy.setAttribute(attributeName, value);
        }
        return cleanProxy.getObject();
    }

    @Override
    public T getObject() {
        return this.domainObject;
    }

    @Override
    public void setAttribute(String attributeName, Object attributeValue) {
        this.updateAttribute(attributeName, attributeValue);
        if (this.useAccessMethods) {
            this.setAttributeUsingMethod(attributeName, attributeValue);
        } else {
            this.setAttributeDirect(attributeName, attributeValue);
        }
    }

    @Override
    public Object getAttribute(String attributeName) {
        if (this.isClean() || !this.attributesActedOn.containsKey(attributeName)) {
            return this.getCleanVersionOfAttribute(attributeName);
        }
        return this.attributesActedOn.get(attributeName).peek();
    }

    @Override
    public void reset() {
        while (!this.isClean()) {
            Iterator<String> it = this.attributesActedOn.keySet().iterator();
            if (!it.hasNext()) continue;
            String attributeName = it.next();
            this.resetAttribute(attributeName);
        }
    }

    @Override
    public void resetAttribute(String attributeName) {
        if (this.isClean(attributeName)) {
            return;
        }
        Object value = this.attributesActedOn.get(attributeName).firstElement();
        this.setAttribute(attributeName, value);
        this.attributesActedOn.remove(attributeName);
        if (this.attributesActedOn.size() == 0) {
            this.attributesActedOn = null;
        }
    }

    @Override
    public Object getCleanVersionOfAttribute(String attributeName) {
        if (!this.isClean(attributeName)) {
            return this.attributesActedOn.get(attributeName).firstElement();
        }
        return this.useAccessMethods ? this.getAttributeUsingMethod(attributeName) : this.getAttributeDirect(attributeName);
    }

    @Override
    public boolean equalsInitialValue(String attributeName, Object value) {
        Object originalValue = this.getCleanVersionOfAttribute(attributeName);
        if (value instanceof String && originalValue instanceof String) {
            return ((String)value).trim().equals(((String)originalValue).trim());
        }
        if ((value = this.convertStringToObjectType((String)value, this.getAttributeType(attributeName))) == null) {
            return originalValue == null;
        }
        return value.equals(originalValue);
    }

    @Override
    public void forceClean(String attributeName, Object value) {
        this.setAttribute(attributeName, value);
        this.forceCleanAttribute(attributeName);
    }

    @Override
    public void forceClean(T o) {
        this.domainObject = o;
        this.attributesActedOn = null;
    }

    private void forceCleanAttribute(String attributeName) {
        if (this.attributesActedOn != null) {
            this.attributesActedOn.remove(attributeName);
            if (this.attributesActedOn.size() == 0) {
                this.attributesActedOn = null;
            }
        }
    }

    @Override
    public void copyStatus(DomainObjectProxy<?> fromProxy, String fromAttributeName, String toAttributeName) {
        if (fromProxy.isClean(fromAttributeName) && !this.isClean(toAttributeName)) {
            this.forceCleanAttribute(toAttributeName);
        } else if (!fromProxy.isClean(fromAttributeName) && this.isClean(toAttributeName)) {
            this.updateAttribute(toAttributeName, this.getAttribute(toAttributeName));
        }
    }

    public String toString() {
        return "Proxy for class: " + this.domainClass.getName() + " -- " + ", object: " + this.domainObject + ", state: " + (this.isClean() ? "clean" : "dirty");
    }

    private Class<?> getAttributeType(String attributeName) {
        if (this.useAccessMethods) {
            String getMethodName = TypeTool.asBeanGetter(attributeName);
            try {
                Method m = this.domainClass.getMethod(getMethodName, null);
                return m.getReturnType();
            }
            catch (NoSuchMethodException e) {
                Object[] msgArgs = new Object[]{"G9Proxy", getMethodName, this.domainClass, e.getMessage()};
                Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
                MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException(e, msg);
            }
        }
        try {
            Field f = this.domainClass.getField(attributeName);
            return f.getType();
        }
        catch (NoSuchFieldException e) {
            Object[] msgArgs = new Object[]{"G9Proxy", attributeName, this.domainClass, e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
            MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(e, msg);
        }
    }

    private Object getAttributeDirect(String attributeName) {
        ReflectiveOperationException ex = null;
        try {
            Field field = this.domainClass.getField(attributeName);
            field.setAccessible(true);
            return field.get(this.domainObject);
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (NoSuchFieldException e) {
            ex = e;
        }
        Object[] msgArgs = new Object[]{"G9Proxy", attributeName, this.domainClass, ex.getMessage()};
        Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
        MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
        throw new G9ClientFrameworkException(ex, msg);
    }

    private Object getAttributeUsingMethod(String attributeName) {
        ReflectiveOperationException ex = null;
        String methodName = TypeTool.asBeanGetter(attributeName);
        try {
            Method getMethod = this.domainClass.getMethod(methodName, null);
            getMethod.setAccessible(true);
            return getMethod.invoke(this.domainObject, (Object[])null);
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        catch (NoSuchMethodException e) {
            ex = e;
            methodName = TypeTool.asBeanBooleanGetter(attributeName);
            try {
                Method getMethod = this.domainClass.getMethod(methodName, null);
                getMethod.setAccessible(true);
                return getMethod.invoke(this.domainObject, (Object[])null);
            }
            catch (IllegalAccessException e2) {
                ex = e2;
            }
            catch (InvocationTargetException e2) {
                ex = e2;
            }
            catch (NoSuchMethodException e2) {
                // empty catch block
            }
        }
        Object[] msgArgs = new Object[]{"G9Proxy", methodName, this.domainClass, ex.getMessage()};
        Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
        MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
        throw new G9ClientFrameworkException(ex, msg);
    }

    private void updateAttribute(String attributeName, Object value) {
        Stack<Object> valueStack;
        if (this.isClean()) {
            this.attributesActedOn = new HashMap<String, Stack<Object>>();
        }
        if (this.attributesActedOn.containsKey(attributeName)) {
            valueStack = this.attributesActedOn.get(attributeName);
        } else {
            valueStack = new Stack<Object>();
            valueStack.push(this.getAttribute(attributeName));
            this.attributesActedOn.put(attributeName, valueStack);
        }
        valueStack.push(value);
    }

    private Object convertStringToObjectType(String stringValue, Class<?> type) {
        boolean zeroValue;
        Object value = null;
        if (stringValue == null) {
            stringValue = "";
        }
        boolean bl = zeroValue = (stringValue = stringValue.trim()).length() == 0;
        if (type == Byte.TYPE) {
            value = zeroValue ? Byte.valueOf((byte)0) : Byte.valueOf(stringValue);
        } else if (type == Byte.class) {
            value = zeroValue ? null : Byte.valueOf(stringValue);
        } else if (type == Short.TYPE) {
            value = zeroValue ? Short.valueOf((short)0) : Short.valueOf(stringValue);
        } else if (type == Short.class) {
            value = zeroValue ? null : Short.valueOf(stringValue);
        } else if (type == Integer.TYPE) {
            value = zeroValue ? Integer.valueOf(0) : Integer.valueOf(stringValue);
        } else if (type == Integer.class) {
            value = zeroValue ? null : Integer.valueOf(stringValue);
        } else if (type == Long.TYPE) {
            value = zeroValue ? Long.valueOf(0L) : Long.valueOf(stringValue);
        } else if (type == Long.class) {
            value = zeroValue ? null : Long.valueOf(stringValue);
        } else if (type == Character.TYPE) {
            value = zeroValue ? Character.valueOf('\u0000') : Character.valueOf(stringValue.charAt(0));
        } else if (type == Character.class) {
            value = zeroValue ? null : Character.valueOf(stringValue.charAt(0));
        } else if (type == Double.TYPE) {
            value = zeroValue ? new Double(0.0) : new Double(stringValue);
        } else if (type == Double.class) {
            value = zeroValue ? null : new Double(stringValue);
        } else if (type == Float.TYPE) {
            value = zeroValue ? new Float(0.0f) : new Float(stringValue);
        } else if (type == Float.class) {
            value = zeroValue ? null : new Float(stringValue);
        } else if (type == Boolean.TYPE) {
            value = zeroValue ? Boolean.valueOf(false) : Boolean.valueOf(stringValue);
        } else if (type == Boolean.class) {
            value = zeroValue ? null : Boolean.valueOf(stringValue);
        } else if (Date.class.isAssignableFrom(type)) {
            value = zeroValue ? null : TypeTool.parse(stringValue);
        } else if (type == Numeric.class) {
            value = zeroValue ? null : new Numeric(stringValue, 0);
        } else if (type == BigDecimal.class) {
            value = zeroValue ? null : new BigDecimal(stringValue);
        } else if (type == String.class) {
            value = stringValue;
        } else if (G9Enumerator.class.isAssignableFrom(type) || type.isEnum()) {
            try {
                if (!zeroValue) {
                    value = EnumUtil.getEnumObject(type.getName(), stringValue);
                }
            }
            catch (G9BaseException ex) {
                Object[] msgArgs = new Object[]{"G9Proxy", type, ex.getMessage()};
                Message msg = MessageSystem.getMessageFactory().getMessage("-1510", msgArgs);
                MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException(ex, msg);
            }
        }
        return value;
    }

    private void setAttributeUsingMethod(String attributeName, Object value) {
        String methodName = TypeTool.asBeanSetter(attributeName);
        Method setMethod = null;
        Method[] allMethods = this.domainClass.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            if (!allMethods[i].getName().equals(methodName)) continue;
            setMethod = allMethods[i];
            break;
        }
        if (setMethod == null) {
            throw new G9BaseException("Could not find set method for attribute " + attributeName);
        }
        if (setMethod.getParameterTypes().length != 1) {
            throw new G9BaseException("Set method for attribute " + attributeName + " has icorrect signature");
        }
        Class<?> paramType = setMethod.getParameterTypes()[0];
        if (paramType != String.class && (value instanceof String || value == null)) {
            value = this.convertStringToObjectType((String)value, paramType);
        }
        assert (paramType != null);
        Exception ex = null;
        try {
            if (value != null && value.getClass().equals(Integer.class) && paramType.equals(Long.class)) {
                value = ((Integer)value).longValue();
            }
            setMethod.setAccessible(true);
            setMethod.invoke(this.domainObject, value);
        }
        catch (IllegalArgumentException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        if (ex != null) {
            Object[] msgArgs = new Object[]{"G9Proxy", methodName, this.domainClass, ex.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
            MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(ex, msg);
        }
    }

    private void setAttributeDirect(String attributeName, Object value) {
        ReflectiveOperationException ex = null;
        try {
            Field f = this.domainClass.getField(attributeName);
            f.setAccessible(true);
            f.set(this.domainObject, value);
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (NoSuchFieldException e) {
            ex = e;
        }
        if (ex != null) {
            Object[] msgArgs = new Object[]{"G9Proxy", attributeName, this.domainClass, ex.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
            MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(ex, msg);
        }
    }

    private T createClone() {
        T clone = null;
        Exception ex = null;
        try {
            clone = this.domainClass.newInstance();
        }
        catch (InstantiationException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        if (ex != null) {
            Object[] msgArgs = new Object[]{"G9Proxy", this.domainClass, ex.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1510", msgArgs);
            MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(msg);
        }
        Field[] allFields = this.domainClass.getFields();
        for (int i = 0; i < allFields.length; ++i) {
            Field field = allFields[i];
            try {
                field.setAccessible(true);
                field.set(clone, field.get(this.domainObject));
            }
            catch (IllegalArgumentException e) {
                ex = e;
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            if (ex == null) continue;
            Object[] msgArgs = new Object[]{"G9Proxy", field.getName(), this.domainClass, ex.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
            MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(ex, msg);
        }
        Method[] allMethods = this.domainClass.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            String methodName = allMethods[i].getName();
            if (!methodName.startsWith("set")) continue;
            try {
                Method getMethod = this.domainClass.getMethod("get" + methodName.substring(3), null);
                allMethods[i].setAccessible(true);
                getMethod.setAccessible(true);
                Object[] args = new Object[]{getMethod.invoke(this.domainObject, (Object[])null)};
                allMethods[i].invoke(clone, args);
            }
            catch (IllegalArgumentException e) {
                ex = e;
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            catch (InvocationTargetException e) {
                ex = e;
            }
            catch (SecurityException e) {
                ex = e;
            }
            catch (NoSuchMethodException e) {
                ex = e;
            }
            if (ex == null) continue;
            Object[] msgArgs = new Object[]{"G9Proxy", methodName, this.domainClass, ex.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
            MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(ex, msg);
        }
        return clone;
    }
}

