/*
 * Decompiled with CFR 0.152.
 */
package no.g9.exception;

import no.g9.message.Message;
import no.g9.message.MessageSystem;

public class G9BaseException
extends RuntimeException {
    private Message errMsg;

    public G9BaseException(Throwable cause) {
        super(cause);
        this.setErrMsg(MessageSystem.getMessageFactory().getMessage("-1000", cause.getLocalizedMessage()));
        this.getErrMsg().setException(cause);
    }

    public G9BaseException(String message, Throwable cause) {
        super(message, cause);
        this.setErrMsg(MessageSystem.getMessageFactory().getMessage("-1000", message));
        this.getErrMsg().setException(cause);
    }

    public G9BaseException(String message) {
        super(message);
        this.setErrMsg(MessageSystem.getMessageFactory().getMessage("-1000", message));
    }

    public G9BaseException() {
    }

    public G9BaseException(Message errMsg) {
        super(errMsg != null ? errMsg.getMessageText() : null);
        this.setErrMsg(errMsg);
    }

    public G9BaseException(Throwable cause, Message errMsg) {
        super(errMsg != null ? errMsg.getMessageText() : null, cause);
        this.setErrMsg(errMsg);
        this.getErrMsg().setException(cause);
    }

    public final void setErrMsg(Message errMsg) {
        this.errMsg = errMsg;
    }

    public final Message getErrMsg() {
        return this.errMsg;
    }

    public static Throwable hasNested(Throwable cause) {
        Throwable t = cause;
        while (t != null) {
            if (t instanceof G9BaseException) {
                return t;
            }
            t = t.getCause();
        }
        return null;
    }
}

