/*
 * Decompiled with CFR 0.152.
 */
package no.g9.message;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import no.g9.message.CLogLevels;
import no.g9.message.MessageContext;
import no.g9.message.MessageReplyType;
import no.g9.message.MessageText;
import no.g9.message.MessageType;
import no.g9.message.MessageTypeEnum;
import no.g9.message.ReplySetType;
import no.g9.message.Severity;

public class Message
implements CLogLevels,
Serializable {
    private Severity severity;
    private List<Message> messages = new LinkedList<Message>();
    private static final int TEXT_SIZE = 2;
    private static Random generator = new Random();
    private final String runtimeId;
    private String messageID;
    private Object[] args;
    private MessageType messageType = MessageTypeEnum.NONE;
    private long logLevel = 0L;
    private String title;
    private String messageText = "";
    private String hint;
    private List<String> description = new ArrayList<String>(2);
    private ReplySetType validReplies = ReplySetType.REPLSET_NONE;
    private MessageReplyType reply = MessageReplyType.REPLY_NONE;
    private String replString = "";
    private File replyFile = null;
    private Throwable thrown;
    private MessageContext context;

    public Message() {
        this(null, new Object[]{null});
    }

    public Message(String messageID) {
        this.messageID = messageID;
        this.runtimeId = String.valueOf(generator.nextLong());
    }

    public Message(String messageID, Object ... args) {
        this.messageID = messageID;
        this.args = args;
        this.runtimeId = String.valueOf(generator.nextLong());
    }

    public Message(String messageID, MessageType messageType, Object ... args) {
        this(messageID, args);
        this.messageType = messageType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Message[").append(this.runtimeId).append(" id ").append(this.messageID).append(" type ").append(this.messageType).append(" text ").append(this.messageText).append("]");
        if (this.reply != null && !MessageReplyType.REPLY_NONE.equals(this.reply)) {
            sb.append("=").append(this.reply);
        } else if (this.replString != null && !"".equals(this.replString)) {
            sb.append("=").append(this.replString);
        } else if (this.replyFile != null) {
            sb.append("=").append(this.replyFile);
        }
        return sb.toString().trim();
    }

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public void setArgs(Object[] pArgs) {
        this.args = (Object[])pArgs.clone();
    }

    public Object[] getArgs() {
        return this.args != null ? (Object[])this.args.clone() : null;
    }

    public void setValidReplies(ReplySetType pReplies) {
        this.validReplies = pReplies;
    }

    public ReplySetType getValidReplies() {
        return this.validReplies;
    }

    public void setReply(MessageReplyType pRepl) {
        this.reply = pRepl;
    }

    public MessageReplyType getReply() {
        return this.reply;
    }

    public void setMsgType(MessageType pMsgType) {
        this.messageType = pMsgType;
    }

    public MessageType getMsgType() {
        return this.messageType;
    }

    public void setLogLevel(long pLogLevel) {
        this.logLevel = pLogLevel;
    }

    public long getLogLevel() {
        return this.logLevel;
    }

    public void setDescription(int index, MessageText txt) {
        this.setDescription(index, txt.toString());
    }

    public void setDescription(int index, String txt) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int currSize = this.description.size();
        if (index >= currSize) {
            for (int i = currSize; i <= index; ++i) {
                this.description.add(null);
            }
        }
        this.description.set(index, txt);
    }

    public void addDescription(String txt) {
        this.description.add(txt);
    }

    public void clearDescription() {
        this.description.clear();
    }

    public String getDescription(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        String mtx = null;
        if (index < this.description.size()) {
            mtx = this.description.get(index);
        }
        return mtx == null ? "" : mtx;
    }

    public String getDescription(String delimiter) {
        StringBuffer sb = new StringBuffer();
        boolean addDelimiter = false;
        for (String s : this.description) {
            if (addDelimiter) {
                if (delimiter != null) {
                    sb.append(delimiter);
                }
            } else {
                addDelimiter = true;
            }
            if (s == null) continue;
            sb.append(s);
        }
        return sb.toString();
    }

    public void addMessage(Message that) {
        if (that == null) {
            return;
        }
        this.messages.add(that);
    }

    public void copy(Message that) {
        if (that == null) {
            return;
        }
        if (this.messageID == null) {
            this.messageID = that.messageID;
        }
        this.logLevel |= that.logLevel;
        if (this.thrown == null) {
            this.thrown = that.thrown;
        }
        if (that.description != null) {
            this.description.addAll(that.description);
        }
        if (this.messageType == null || this.messageType.equals(MessageTypeEnum.NONE)) {
            this.messageType = that.messageType;
        }
        if (this.reply == null || this.reply.equals(MessageReplyType.REPLY_NONE)) {
            this.reply = that.reply;
        }
        if (this.validReplies == null || this.validReplies.equals(ReplySetType.REPLSET_NONE)) {
            this.validReplies = that.validReplies;
        }
        if (Message.isEmpty(this.messageText)) {
            this.messageText = that.messageText;
        }
        if (Message.isEmpty(this.hint)) {
            this.hint = that.hint;
        }
        if (Message.isEmpty(this.title)) {
            this.title = that.title;
        }
        if (Message.isEmpty(this.replString)) {
            this.replString = that.replString;
        }
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public void setTitle(String pTitle) {
        this.title = pTitle;
    }

    public String getTitle() {
        return this.title;
    }

    public void setMessageText(String pMessageText) {
        this.messageText = pMessageText == null ? "" : pMessageText;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void setHint(String pHint) {
        this.hint = pHint;
    }

    public String getHint() {
        return this.hint;
    }

    public void setException(Throwable exc) {
        this.thrown = exc;
    }

    public Throwable getException() {
        return this.thrown;
    }

    public MessageContext getContext() {
        return this.context;
    }

    public void setContext(MessageContext context) {
        this.context = context;
    }

    public void setReplString(String newRepl) {
        this.replString = newRepl == null ? "" : newRepl;
    }

    public String getReplString() {
        return this.replString;
    }

    public File getReplyFile() {
        return this.replyFile;
    }

    public void setReplyFile(File replyFile) {
        this.replyFile = replyFile;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public List<Message> getMessages() {
        return this.messages;
    }
}

