/*
 * Decompiled with CFR 0.152.
 */
package no.g9.os;

import java.util.Iterator;
import java.util.List;
import no.g9.os.AttributeConstant;
import no.g9.os.Key;
import no.g9.os.OSRole;

public class KeyTool {
    public static final byte UNDEFINED_VALUE_BYTE = 0;
    public static final char UNDEFINED_VALUE_CHAR = '\u0000';
    public static final int UNDEFINED_VALUE_INT = 0;
    public static final long UNDEFINED_VALUE_LONG = 0L;
    public static final float UNDEFINED_VALUE_FLOAT = 0.0f;
    public static final double UNDEFINED_VALUE_DOUBLE = 0.0;
    public static final boolean UNDEFINED_VALUE_BOOLEAN = false;
    public static final String UNDEFINED_VALUE_STRING = "";

    public static Key getCompleteUniqueKey(Object instance, OSRole<?> role) {
        List<Key> keys = role.getKeys();
        Iterator<Key> keyIterator = keys.iterator();
        Key found = null;
        while (found == null && keyIterator.hasNext()) {
            Key key = keyIterator.next();
            AttributeConstant[] attributes = key.getAttributes();
            if (!KeyTool.attributesDefined(instance, role, attributes)) continue;
            found = key;
        }
        return found;
    }

    public static boolean attributesDefined(Object instance, OSRole<?> role, AttributeConstant[] attributes) {
        boolean isDefined = true;
        for (int i = 0; i < attributes.length && isDefined; ++i) {
            isDefined = KeyTool.isDefined(role.getValue(instance, attributes[i]));
        }
        return isDefined;
    }

    public static boolean isDefined(byte primitive) {
        return primitive != 0;
    }

    public static boolean isDefined(Byte b) {
        return b != null ? KeyTool.isDefined((byte)b) : false;
    }

    public static boolean isDefined(char primitive) {
        return primitive != '\u0000';
    }

    public static boolean isDefined(Character c) {
        return c != null ? KeyTool.isDefined(c.charValue()) : false;
    }

    public static boolean isDefined(int primitive) {
        return primitive != 0;
    }

    public static boolean isDefined(Integer i) {
        return i != null ? KeyTool.isDefined((int)i) : false;
    }

    public static boolean isDefined(long primitive) {
        return primitive != 0L;
    }

    public static boolean isDefined(Long l) {
        return l != null ? KeyTool.isDefined((long)l) : false;
    }

    public static boolean isDefined(float primitive) {
        return primitive != 0.0f;
    }

    public static boolean isDefined(Float f) {
        return f != null ? KeyTool.isDefined(f.floatValue()) : false;
    }

    public static boolean isDefined(double primitive) {
        return primitive != 0.0;
    }

    public static boolean isDefined(Double d) {
        return d != null ? KeyTool.isDefined((double)d) : false;
    }

    public static boolean isDefined(boolean primitive) {
        return primitive;
    }

    public static boolean isDefined(Boolean b) {
        return b != null ? KeyTool.isDefined((boolean)b) : false;
    }

    public static boolean isDefined(String s) {
        return s != null && !UNDEFINED_VALUE_STRING.equals(s);
    }

    public static boolean isDefined(Object o) {
        if (o instanceof String) {
            return KeyTool.isDefined((String)o);
        }
        if (o instanceof Byte) {
            return KeyTool.isDefined((Byte)o);
        }
        if (o instanceof Character) {
            return KeyTool.isDefined((Character)o);
        }
        if (o instanceof Integer) {
            return KeyTool.isDefined((Integer)o);
        }
        if (o instanceof Long) {
            return KeyTool.isDefined((Long)o);
        }
        if (o instanceof Float) {
            return KeyTool.isDefined((Float)o);
        }
        if (o instanceof Double) {
            return KeyTool.isDefined((Double)o);
        }
        if (o instanceof Boolean) {
            return KeyTool.isDefined((Boolean)o);
        }
        return o != null;
    }
}

