/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support;

import java.util.HashMap;
import java.util.Map;
import no.g9.exception.G9BaseException;
import no.g9.message.MessageSystem;
import no.g9.support.RegistrySet;

public class Registry
extends RegistrySet {
    private static Registry regInstance;
    private static final String PROPERTIES_FILE = "g9.config";
    public static final String SRV_APP_PRE = "ServiceApplication";
    public static final String DEFAULT_SRV = "DefaultServicePackage";
    public static final String DEFAULT_DBM = "DefaultDatabaseMapping";
    public static final String DEFAULT_DBC = "DefaultDatabaseContext";
    public static final String DEFAULT_XMLCONV_PACKAGE = "DefaultXmlConvertPackage";
    public static final String DEFAULT_SPREADSHEET_PACKAGE = "DefaultSpreadsheetExporterPackage";
    private static final String DBC_PRE = "Database.Context";
    private static final String DBS_PRE = "Database.Server";
    private static final String DBM_PRE = "Database.Mapping";
    private Map<String, Map<String, RegistrySet>> propertyTypes = new HashMap<String, Map<String, RegistrySet>>();

    private Registry() {
        super(PROPERTIES_FILE, null);
    }

    public String getApplicationProperty(String fileName, String propName) {
        return this.getRegistrySet(SRV_APP_PRE, fileName).getProperty(propName);
    }

    public String getDatabaseContextProperty(String context, String propName) {
        return this.getG9Property("Database.Context." + context + "." + propName);
    }

    public String getDatabaseServerProperty(String server, String propName) {
        return this.getG9Property("Database.Server." + server + "." + propName);
    }

    public String getDatabaseMappingProperty(String mapping, String propName) {
        return this.getG9Property("Database.Mapping." + mapping + "." + propName);
    }

    public String getG9Property(String propName) {
        String propValue = this.props.getProperty(propName);
        return propValue;
    }

    public boolean hasG9Propery(String propName) {
        return propName != null && this.props.getProperty(propName) != null;
    }

    public String getProperty(String setType, String setName, String propName) {
        return this.getRegistrySet(setType, setName).getProperty(propName);
    }

    public RegistrySet getRegistrySet(String setType, String setName) {
        RegistrySet registrySet;
        Map<String, RegistrySet> typeMap = this.propertyTypes.get(setType);
        if (typeMap == null) {
            typeMap = new HashMap<String, RegistrySet>();
            this.propertyTypes.put(setType, typeMap);
        }
        if ((registrySet = typeMap.get(setName)) == null) {
            registrySet = new RegistrySet(setName, null);
            typeMap.put(setName, registrySet);
        }
        return registrySet;
    }

    public static Registry getRegistry() {
        if (regInstance == null) {
            try {
                regInstance = new Registry();
            }
            catch (G9BaseException e) {
                MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(e.getErrMsg());
                throw e;
            }
        }
        return regInstance;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

