/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import no.g9.exception.G9BaseException;
import no.g9.message.Message;
import no.g9.message.MessageSystem;

public class RegistrySet {
    protected Properties props;
    private static final String PROPERTIES_EXTENSION = ".properties";

    public RegistrySet(String name, String path) {
        String fullName = name + PROPERTIES_EXTENSION;
        this.props = path == null || path.equals("") ? RegistrySet.loadProperties(fullName, true) : RegistrySet.loadProperties(path + fullName, false);
    }

    public String getProperty(String propName) {
        String propValue = this.props.getProperty(propName);
        return propValue;
    }

    public static Properties loadProperties(String fileName, boolean useClassLoader) {
        Properties props = new Properties();
        try {
            InputStream in = null;
            in = useClassLoader ? RegistrySet.class.getClassLoader().getResourceAsStream(fileName) : RegistrySet.class.getResourceAsStream(fileName);
            if (in != null) {
                props.load(in);
                in.close();
            }
        }
        catch (IOException ex) {
            Object[] args = new Object[]{fileName};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1102", args);
            MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9BaseException(msg);
        }
        return props;
    }

    public Iterator<Map.Entry<Object, Object>> iterator() {
        return this.props.entrySet().iterator();
    }
}

