/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support.transport;

import java.util.HashMap;
import java.util.Map;
import no.esito.log.Logger;
import no.g9.os.OSRole;
import no.g9.support.transport.DomainTransportTransfer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DomainTransportConverterRegistry
implements ApplicationContextAware,
DisposableBean {
    private HashMap<SourceTarget, DomainTransportTransfer<?, ?>> domainTransporConverters;
    private HashMap<OSRole<?>, DomainTransportTransfer<?, ?>> domainTransporConvertersPerOSRole;
    private ApplicationContext applicationContext;
    private static final Logger logger = Logger.getLogger(DomainTransportConverterRegistry.class);

    private synchronized <S, T> void addConverter(DomainTransportTransfer<S, T> converter) {
        Assert.notNull(converter, (String)"converter must not be null");
        Class<?>[] typeInfo = this.getRequiredTypeInfo(converter);
        SourceTarget convertiblePair1 = new SourceTarget(typeInfo[0], typeInfo[1]);
        SourceTarget convertiblePair2 = new SourceTarget(typeInfo[1], typeInfo[0]);
        this.getDomainTransporConverters().put(convertiblePair1, converter);
        this.getDomainTransporConverters().put(convertiblePair2, converter);
        if (logger.isDebugEnabled()) {
            logger.debug("Adding converter for role '" + converter.getOSRole() + "':" + convertiblePair1);
        }
        Assert.notNull(converter.getOSRole(), (String)"converter's osrole must not be null");
        this.getDomainTransporConvertersPerOSRole().put(converter.getOSRole(), converter);
    }

    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        return this.getConverter(sourceType, targetType) != null;
    }

    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.getConverter(sourceType, targetType) != null;
    }

    public <S, T> DomainTransportTransfer<S, T> getConverter(Class<?> sourceType, Class<?> targetType) {
        SourceTarget typeInfo = new SourceTarget(sourceType, targetType);
        return this.getDomainTransporConverters().get(typeInfo);
    }

    public <S, T> DomainTransportTransfer<S, T> getConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
        SourceTarget typeInfo = new SourceTarget(sourceType, targetType);
        return this.getDomainTransporConverters().get(typeInfo);
    }

    public <S, T> DomainTransportTransfer<S, T> getConverter(OSRole<?> osRole) {
        return this.getDomainTransporConvertersPerOSRole().get(osRole);
    }

    private Class<?>[] getRequiredTypeInfo(Object converter) {
        return GenericTypeResolver.resolveTypeArguments(converter.getClass(), DomainTransportTransfer.class);
    }

    private Map<SourceTarget, DomainTransportTransfer<?, ?>> getDomainTransporConverters() {
        if (this.domainTransporConverters == null) {
            this.initConverters();
        }
        return this.domainTransporConverters;
    }

    private Map<OSRole<?>, DomainTransportTransfer<?, ?>> getDomainTransporConvertersPerOSRole() {
        if (this.domainTransporConvertersPerOSRole == null) {
            this.initConverters();
        }
        return this.domainTransporConvertersPerOSRole;
    }

    synchronized void initConverters() {
        this.domainTransporConverters = new HashMap();
        this.domainTransporConvertersPerOSRole = new HashMap();
        if (logger.isDebugEnabled()) {
            logger.debug("initConverters()");
        }
        Map beans = this.getApplicationContext().getBeansOfType(DomainTransportTransfer.class);
        for (DomainTransportTransfer bean : beans.values()) {
            this.addConverter(bean);
        }
    }

    public void destroy() throws Exception {
        this.domainTransporConverters = null;
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.applicationContext = ctx;
    }

    private ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public static final class SourceTarget {
        private final Class<?> sourceType;
        private final Class<?> targetType;

        public SourceTarget(Class<?> sourceType, Class<?> targetType) {
            Assert.notNull(sourceType, (String)"Source type must not be null");
            Assert.notNull(targetType, (String)"Target type must not be null");
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public SourceTarget(TypeDescriptor sourceType, TypeDescriptor targetType) {
            Assert.notNull((Object)sourceType, (String)"Source type must not be null");
            Assert.notNull((Object)targetType, (String)"Target type must not be null");
            this.sourceType = sourceType.getType();
            this.targetType = targetType.getType();
        }

        public Class<?> getSourceType() {
            return this.sourceType;
        }

        public Class<?> getTargetType() {
            return this.targetType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.sourceType == null ? 0 : this.sourceType.hashCode());
            result = 31 * result + (this.targetType == null ? 0 : this.targetType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceTarget other = (SourceTarget)obj;
            if (this.sourceType == null ? other.sourceType != null : !this.sourceType.equals(other.sourceType)) {
                return false;
            }
            return !(this.targetType == null ? other.targetType != null : !this.targetType.equals(other.targetType));
        }

        public String toString() {
            return "SourceTarget [sourceType=" + this.sourceType + ", targetType=" + this.targetType + "]";
        }
    }
}

