/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.exception;

import no.g9.message.Message;

/**
 * The exception class for client code.
 */
public class G9ClientFrameworkException extends G9ClientException {

    /**
     * Constructor with an existing Message and a wrapped exception.
     *
     * @param cause Nested exception
     * @param errMsg Message
     */
    public G9ClientFrameworkException(final Throwable cause, final Message errMsg) {
        super(cause, errMsg);
    }

    /**
     * Constructor with an existing Message.
     *
     * @param errMsg Message
     */
    public G9ClientFrameworkException(final Message errMsg) {
        super(errMsg);
    }

    /**
     * (missing javadoc)
     */
    public G9ClientFrameworkException() {
        super();
    }

    /**
     * @param message (missing javadoc)
     */
    public G9ClientFrameworkException(String message) {
        super(message);
    }

    /**
     * @param message (missing javadoc)
     * @param cause (missing javadoc)
     */
    public G9ClientFrameworkException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * @param cause (missing javadoc)
     */
    public G9ClientFrameworkException(Throwable cause) {
        super(cause);
    }

}
