/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.message;

/**
 * Non-variable part of a parsed message.
 */
class FixedTextPart implements ITextPart {

    /** This fixed text. */
    private final String text;

    /**
     * Default constructor for FixedTextPart.
     * 
     * @param txt Text contents
     */
    public FixedTextPart(final String txt) {
        super();
        this.text = txt;
    }

    /**
     * Append this message part to the total message.
     * 
     * @param sb The message to append to.
     * @param singleLine Ignored
     * @param args Ignored
     * @see ITextPart#appendPart(StringBuffer, boolean, Object[])
     */
    @Override
    public void appendPart(final StringBuffer sb, final boolean singleLine,
            final Object[] args) {
        if (sb != null) {
            sb.append(toString());
        }
    }

    /**
     * Overrides Object.clone. Makes a copy of this object.
     * 
     * @return A clone of this Object.
     * @see java.lang.Object#clone()
     */
    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    /**
     * Returns this message part as a string.
     * 
     * @return The text content (empty string if null).
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        if (this.text == null) {
            return "";
        }
        return this.text;
    }

}
