/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.message;

/**
 * This interface lets the client dispatch messages to the message system. 
 * 
 * Usage from inside the controller:
 * <code>getMessageDispatcher().dispatch("some.message.id", "Message parameter 1", "Message parameter 2");</code>
 */
public interface MessageDispatcher {
	/**
	 * Creates a message and dispatces it to the message system.
	 * 
	 * @param id The message identifier
	 * @param args The arguments needed to create the message text.
	 * @return The message reply. If the <code>MessageInteractor</code> does not interact with this message this value might be null.
	 */
	public MessageReply dispatch(String id, Object... args);

	/**
	 * Dispatches a message to the message system.
	 * @param message The message to dispatch
	 * @return The message reply. If the <code>MessageInteractor</code> does not interact with this message this value might be null.
	 */
	public MessageReply dispatch(Message message);

	/**
	 * Creates a message and dispatces it to the message system.
	 * 
	 * @param id The message identifier
	 * @param exception The exception associated with this message.
	 * @param args The arguments needed to create the message text.

	 * @return The message reply. If the <code>MessageInteractor</code> does not interact with this message this value might be null.
	 */
	public MessageReply dispatch(String id, Throwable exception, Object... args);
}