/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.service.print;

import java.io.File;
import java.io.OutputStream;
import java.util.Map;

import no.esito.util.BeanID;
import no.esito.util.G9PropertyName;

import org.w3c.dom.Document;

/**
 * The interface handles export to other formats, such as PDF.
 */
@BeanID("exportService")
@G9PropertyName("ExportService")
public interface ExportService {
    /**
     * Fills and exports the report to the given URI.
     *
     * @param data          Data to be printed formed in a Document
     * @param dialogName    The template to be filled and printed
     * @param file          File to place the result PDF in
     */
    public void exportToPDF(Document data, String dialogName, File file);

    /**
     * Fills and exports the report to PDF.
     *
     * @param data          Data to be printed formed in a Document
     * @param dialogName    The template to be filled and printed
     * @param outputStream  The output stream to put the PDF in
     */
    public void exportToPDF(Document data, String dialogName, OutputStream outputStream);

    /**
     * Fills and exports the report to the given URI.
     *
     * @param data          Data to be printed formed in a Document
     * @param dialogName    The template to be filled and printed
     * @param file          File to place the result PDF in
     * @param params        Parameters to supplement the data towards the print
     */
    public void exportToPDF(Document data, String dialogName, File file, Map<String, Object> params);

    /**
     * Fills and exports the report to PDF.
     *
     * @param data          Data to be printed formed in a Document
     * @param dialogName    The template to be filled and printed
     * @param outputStream  The output stream to put the PDF in
     * @param params        Parameters to supplement the data towards the print
     */
    public void exportToPDF(Document data,
                            String dialogName,
                            OutputStream outputStream,
                            Map<String, Object> params);
}
