/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support;

import java.util.Locale;

/** A generic provider of resources.
 *
 * @param <T> the resource type
 */
public interface ResourceProvider<T> {

	/**
     * Try to get a given resource.
     *
     * @param bundleName Supposed bundle, may be null
     * @param key The lookup key
     * @param locale The message locale, may be null
     * @return The requested resource, or null if unknown
     */
    T getResource(String bundleName, String key, Locale locale);

}