/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support.convert;

/**
 * A context for value convertion for Jasper reports.
 * 
 * @author maw
 *
 */
public class JasperConvertContext extends ConvertContext {

    private String displayRule;
    private int genovaDataType;
    private int precision;
    private int scale;
    private int caseConversion;
    private int inputLength;
    private boolean blankWhenZero;
    
    /**
     * Default constructor. 
     * 
     * @param displayRule display rule
     * @param genovaDataType g9 data type
     * @param precision precision
     * @param scale scale
     * @param caseConversion case conversion
     * @param inputLength field length
     * @param blankWhenZero blank when zero
     */
    public JasperConvertContext(
            final String displayRule,
            final int genovaDataType,
            final int precision,
            final int scale,
            final int caseConversion,
            final int inputLength,
            final boolean blankWhenZero) {
        this.displayRule= displayRule;
        this.genovaDataType= genovaDataType;
        this.precision= precision;
        this.scale= scale;
        this.caseConversion= caseConversion;
        this.inputLength= inputLength;
        this.blankWhenZero= blankWhenZero;
    }

    /**
     * Get the display rule.
     * 
     * @return display rule
     */
    public String getDisplayRule() {
        return displayRule;
    }

    /**
     * Set the display rule.
     * 
     * @param displayRule display rule
     */
    public void setDisplayRule(String displayRule) {
        this.displayRule= displayRule;
    }

    /**
     * Gets the g9 data type.
     * 
     * @return g9 data type
     */
    public int getGenovaDataType() {
        return genovaDataType;
    }

    /**
     * Sets the g9 data type.
     * 
     * @param genovaDataType the g9 data type
     */
    public void setGenovaDataType(int genovaDataType) {
        this.genovaDataType= genovaDataType;
    }

    /**
     * Gets the precision.
     * 
     * @return precision
     */
    public int getPrecision() {
        return precision;
    }

    /**
     * Sets the precision.
     * 
     * @param precision precision
     */
    public void setPrecision(int precision) {
        this.precision= precision;
    }

    /**
     * Gets the scale.
     * 
     * @return scale
     */
    public int getScale() {
        return scale;
    }

    /**
     * Sets the scale.
     * 
     * @param scale scale
     */
    public void setScale(int scale) {
        this.scale= scale;
    }

    /**
     * Gets the case conversion.
     * 
     * @return case conversion
     */
    public int getCaseConversion() {
        return caseConversion;
    }

    /**
     * Sets the case conversion.
     * 
     * @param caseConversion case conversion
     */
    public void setCaseConversion(int caseConversion) {
        this.caseConversion= caseConversion;
    }

    /**
     * Gets the input length.
     * 
     * @return input length
     */
    public int getinputLength() {
        return inputLength;
    }

    /**
     * Sets the input length.
     * 
     * @param inputLength input length
     */
    public void setinputLength(int inputLength) {
        this.inputLength= inputLength;
    }

    /**
     * Is blank when zero.
     * 
     * @return blankWhenZero
     */
    public boolean isBlankWhenZero() {
        return blankWhenZero;
    }

    /**
     * Sets blank when zero.
     * 
     * @param blankWhenZero blank when zero
     */
    public void setBlankWhenZero(boolean blankWhenZero) {
        this.blankWhenZero= blankWhenZero;
    }
}
