/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support.convert;

/**
 * A context for a value convertion.
 *
 * The context contains the name of the attribute, the name of the role,
 * the domain object, and the ObjectSelection.
 *
 */
public class OSConvertContext extends ConvertContext {

    private String attributeName;
    private String roleName;
    private String objectSelectionName;
    private Object domainObject;

    /**
     * Constructs a new ConvertContext using the input parameters.
     *
     * @param attributeName (missing javadoc)
     * @param roleName (missing javadoc)
     * @param objectSelectionName (missing javadoc)
     * @param domainObject (missing javadoc)
     */
    public OSConvertContext(String attributeName, String roleName, String objectSelectionName, Object domainObject) {
        this.attributeName = attributeName;
        this.roleName = roleName;
        this.objectSelectionName = objectSelectionName;
        this.domainObject = domainObject;
    }

    /**
     * Returns the name of the attribute we want to convert
     *
     * @return the name of the attribute we want to convert
     */
    public String getAttributeName() {
        return attributeName;
    }

    /**
     * Sets the name of the attribute we want to convert.
     *
     * @param attributeName (missing javadoc)
     */
    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    /**
     * Returns the name of the role the attribute is part of.
     *
     * @return the name of the role the attribute is part of
     */
    public String getRoleName() {
        return roleName;
    }

    /**
     * Sets the name of the role the attribute is part of.
     *
     * @param roleName (missing javadoc)
     */
    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    /**
     * Returns the domain object that contains the attribute.
     *
     * @return the domain object that contains the attribute
     */
    public Object getDomainObject() {
        return domainObject;
    }

    /**
     * Sets the domain object that contains the attribute.
     *
     * @param domainObject (missing javadoc)
     */
    public void setDomainObject(Object domainObject) {
        this.domainObject = domainObject;
    }

    /**
     * Returns the name of the object selection the attribute is a part of.
     *
     * @return the name of the object selection the attribute is a part of
     */
    public String getObjectSelectionName() {
        return objectSelectionName;
    }

    /**
     * Sets the name of the object selection the attribute is a part of.
     *
     * @param objectSelectionName (missing javadoc)
     */
    public void setObjectSelectionName(String objectSelectionName) {
        this.objectSelectionName = objectSelectionName;
    }

}