/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support.convert;

import no.g9.support.G9Enumerator;

/**
 * A simple converter that converts an Object to a String by simply calling
 * on toString on that Object.
 *
 */
public class SimpleValueConverter implements ValueConverter {

    @SuppressWarnings("deprecation")
	@Override
    public String convertToString(Object value, ConvertContext context) {
        if (value == null) return null;
        if (value.getClass().getSuperclass() == G9Enumerator.class) {
            return ((G9Enumerator)value).currentAsName();
        }
        if (value.getClass().isEnum()) {
            return (((Enum<?>)value).name());
        }
        return value.toString();
    }

    @Override
    public Object convertToObject(String value, ConvertContext context) {
        if (value == null) return null;
        return value;
    }

}
