/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support.xml;

import no.esito.log.Logger;
import no.esito.util.StringUtil;
import no.g9.support.ClientContext;
import no.g9.support.ObjectFactory;
import no.g9.support.ObjectSelection;
import no.g9.support.Registry;

import org.w3c.dom.Document;

/**
 * Locates the converter implementation and delegates. 
 *
 */
public class DefaultXmlConverter implements XmlConverter {

	private Logger log = Logger.getLogger(DefaultXmlConverter.class);

	private static final String XML_CONVERTER = ".xmlConverter";
	
	private static final String CONVERTER_SUFFIX = "XmlConverter";

	@Override
    public Document convert(ObjectSelection objectSelection, ClientContext ctx) {
		return getConverter(objectSelection).convert(objectSelection, ctx);
	}

	private XmlConverter getConverter(ObjectSelection objectSelection) {
		String converterName = getConverterName(objectSelection);
		log.info("Using converter: " + converterName);
		XmlConverter converter = (XmlConverter) ObjectFactory.newObject(converterName);
		
		return converter; 
	}

	private String getConverterName(ObjectSelection objectSelection) {
		String converterName = null;
		String propFileName = objectSelection.getApplicationName()
				+ XML_CONVERTER;
		Registry reg = Registry.getRegistry();
		String propName = null;

        propName= objectSelection.getObjectSelectionName();
        converterName= reg.getApplicationProperty(propFileName, propName);
        if (converterName == null) {
			propName = Registry.SRV_APP_PRE + "."
					+ objectSelection.getApplicationName() + "."
					+ Registry.DEFAULT_XMLCONV_PACKAGE;
			log.info("propName: " + propName);

			converterName = reg.getG9Property(propName) + "."
					+ objectSelection.getObjectSelectionName().toLowerCase()
					+ "." + StringUtil.toFirstUpper(objectSelection.getObjectSelectionName()) + CONVERTER_SUFFIX;
		}

		return converterName;

	}
}
