/*
 * Decompiled with CFR 0.152.
 */
package no.esito.log;

import org.apache.logging.log4j.LogManager;

public final class Logger {
    private final org.apache.logging.log4j.Logger delegate;

    private Logger(org.apache.logging.log4j.Logger delegate) {
        this.delegate = delegate;
    }

    public static Logger getLogger(String name) {
        return new Logger(LogManager.getLogger((String)name));
    }

    public static Logger getLogger(Class<?> clazz) {
        return new Logger(LogManager.getLogger(clazz));
    }

    public void trace(Object message) {
        this.delegate.trace(message);
    }

    public void trace(Object message, Throwable t) {
        this.delegate.trace(message, t);
    }

    public void debug(Object message) {
        this.delegate.debug(message);
    }

    public void debug(Object message, Throwable t) {
        this.delegate.debug(message, t);
    }

    public void error(Object message) {
        this.delegate.error(message);
    }

    public void error(Object message, Throwable t) {
        this.delegate.error(message, t);
    }

    public void fatal(Object message) {
        this.delegate.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        this.delegate.fatal(message, t);
    }

    public void info(Object message) {
        this.delegate.info(message);
    }

    public void info(Object message, Throwable t) {
        this.delegate.info(message, t);
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public void warn(Object message) {
        this.delegate.warn(message);
    }

    public void warn(Object message, Throwable t) {
        this.delegate.warn(message, t);
    }

    public void bark() {
        if (this.isTraceEnabled()) {
            String invokerNameAndLineNumber = this.getInvokerNameAndLineNumber();
            this.trace(invokerNameAndLineNumber);
        }
    }

    private String getInvokerNameAndLineNumber() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        for (int i = 2; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            if (stackTraceElement.getClassName().equals(this.getClass().getName())) continue;
            String s = "Barking from method " + stackTraceElement.getMethodName();
            s = s + ", at line:" + stackTraceElement.getLineNumber() + ".";
            return s;
        }
        return null;
    }

    public static String formatParameters(Object[] parameters) {
        int i = 0;
        StringBuffer sb = new StringBuffer();
        while (i < parameters.length) {
            String paramName = null;
            String paramValue = null;
            paramName = String.valueOf(parameters[i]);
            if (++i < parameters.length) {
                paramValue = String.valueOf(parameters[i]);
                ++i;
            }
            sb.append(paramName + " [" + paramValue + "]" + ", ");
        }
        return sb.substring(0, sb.length() - 2);
    }
}

