/*
 * Decompiled with CFR 0.152.
 */
package no.esito.spring.aspect;

import no.esito.log.Logger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class MethodCallProfilerAspect
implements MethodInterceptor {
    private static Logger log = Logger.getLogger(MethodCallProfilerAspect.class);

    public MethodCallProfilerAspect() {
        log.debug("Finished constructing MethodCallProfilerAspect.");
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object object;
        block6: {
            long time = 0L;
            String invokeString = null;
            boolean throwableThrown = false;
            if (log.isDebugEnabled()) {
                invokeString = invocation.getThis().getClass().getCanonicalName() + "." + invocation.getMethod().getName();
                log.debug("Invoking " + invokeString);
                time = System.currentTimeMillis();
            }
            try {
                object = invocation.proceed();
                if (!log.isDebugEnabled()) break block6;
            }
            catch (Throwable e) {
                try {
                    throwableThrown = true;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (log.isDebugEnabled()) {
                        time = System.currentTimeMillis() - time;
                        log.debug(invokeString + (throwableThrown ? " failed" : " returned") + " in " + time + " milliseconds.");
                    }
                    throw throwable;
                }
            }
            time = System.currentTimeMillis() - time;
            log.debug(invokeString + (throwableThrown ? " failed" : " returned") + " in " + time + " milliseconds.");
        }
        return object;
    }
}

