/*
 * Decompiled with CFR 0.152.
 */
package no.esito.util;

import java.lang.reflect.Method;
import no.g9.exception.G9BaseException;
import no.g9.support.G9Enumerator;
import no.g9.support.ObjectFactory;

public class EnumUtil {
    public static <T> T getEnumObject(String enumClassName, int value) {
        Object enumValue = null;
        Class<?> enumClass = null;
        try {
            enumClass = Class.forName(enumClassName);
            if (enumClass.isEnum()) {
                Method get = enumClass.getMethod("get", Integer.TYPE);
                enumValue = get.invoke(null, value);
            } else {
                G9Enumerator geVal = (G9Enumerator)ObjectFactory.newObject(enumClassName);
                geVal.setCurrentValue(value);
                enumValue = geVal;
            }
        }
        catch (Exception e) {
            throw new G9BaseException("Unable to get enum object", e);
        }
        return (T)enumValue;
    }

    public static <T> T getEnumObject(String enumClassName, String literal) {
        Object enumValue;
        block5: {
            enumValue = null;
            Class<?> enumClass = null;
            try {
                enumClass = Class.forName(enumClassName);
                if (enumClass.isEnum()) {
                    Method get = enumClass.getMethod("get", String.class);
                    enumValue = get.invoke(null, literal);
                    break block5;
                }
                G9Enumerator geVal = (G9Enumerator)ObjectFactory.newObject(enumClassName);
                try {
                    Method toValue = geVal.getClass().getMethod("toValue", String.class);
                    int curVal = (Integer)toValue.invoke(null, literal);
                    geVal.setCurrentValue(curVal);
                    enumValue = geVal;
                }
                catch (Exception e) {
                    throw new G9BaseException("Unable to get enum object", e);
                }
            }
            catch (Exception e) {
                throw new G9BaseException("Unable to get enum object", e);
            }
        }
        return (T)enumValue;
    }

    public static int getEnumValue(Object enumObject) {
        if (enumObject == null) {
            throw new IllegalArgumentException("Enum value null is not allowed");
        }
        if (enumObject instanceof G9Enumerator) {
            return ((G9Enumerator)enumObject).getCurrentValue();
        }
        try {
            Method getValue = enumObject.getClass().getMethod("getValue", null);
            return (Integer)getValue.invoke(enumObject, (Object[])null);
        }
        catch (Exception e) {
            throw new G9BaseException("Unable to get enum value", e);
        }
    }

    public static String getEnumLiteral(Object enumObject) {
        if (enumObject == null) {
            throw new IllegalArgumentException("Enum value null is not allowed");
        }
        if (enumObject instanceof G9Enumerator) {
            try {
                Method toTitle = enumObject.getClass().getMethod("toTitle", Integer.TYPE);
                return (String)toTitle.invoke(null, ((G9Enumerator)enumObject).getCurrentValue());
            }
            catch (Exception e) {
                throw new G9BaseException("Unable to get enum literal", e);
            }
        }
        try {
            Method getValue = enumObject.getClass().getMethod("getLiteral", null);
            return (String)getValue.invoke(enumObject, (Object[])null);
        }
        catch (Exception e) {
            throw new G9BaseException("Unable to get enum literal", e);
        }
    }
}

