/*
 * Decompiled with CFR 0.152.
 */
package no.g9.exception;

public class GeneralException
extends Exception {
    protected int errorCode;
    protected String errorMessage;
    protected int subSystem;
    protected boolean logException;
    protected boolean exceptionIsLogged;
    protected int exceptionSeriousCode;
    protected Throwable originalException;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int FATAL_ERROR = 3;

    public int getErrorCode() {
        return this.errorCode;
    }

    public GeneralException() {
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getSubSystem() {
        return this.subSystem;
    }

    public boolean shouldExceptionBeLogged() {
        return this.logException;
    }

    public boolean exceptionLogged() {
        return this.exceptionIsLogged;
    }

    public int exceptionSeriousness() {
        return this.exceptionSeriousCode;
    }

    public String exceptionSeriousnessToString() {
        switch (this.exceptionSeriousCode) {
            case 1: {
                return "warning";
            }
            case 2: {
                return "error";
            }
            case 3: {
                return "fatal error";
            }
        }
        return "uncategorized error";
    }

    public Throwable getOriginalException() {
        return this.originalException;
    }

    public GeneralException(int errorCode, String errorMessage, int subsystem, boolean shouldBeLogged, int seriousness, Throwable originalException) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.subSystem = subsystem;
        this.logException = shouldBeLogged;
        this.exceptionSeriousCode = seriousness;
        this.originalException = originalException;
        this.log();
    }

    protected void log() {
        if (!this.logException || this.exceptionIsLogged) {
            return;
        }
        System.out.println(this.toString());
        this.exceptionIsLogged = true;
    }

    @Override
    public String toString() {
        return this.exceptionSeriousnessToString() + " - CODE:" + this.errorCode + ":" + this.getMessage();
    }

    public String toStringSuper() {
        return super.toString();
    }
}

