/*
 * Decompiled with CFR 0.152.
 */
package no.g9.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import no.g9.message.FixedTextPart;
import no.g9.message.ITextPart;
import no.g9.message.StdParser;

public class MessageText
implements Serializable,
Cloneable {
    private static final int INITCAP = 4;
    private final Object id;
    private String raw;
    private final List<ITextPart> parsed = new ArrayList<ITextPart>(4);
    private String expanded = "";

    public MessageText() {
        this(null, "");
    }

    public MessageText(String messageID, String pRawText) {
        String rawText = pRawText == null ? "" : pRawText;
        this.id = messageID;
        this.raw = rawText;
        this.expanded = rawText;
    }

    public MessageText(String text) {
        this(null, text);
        this.parsed.add(new FixedTextPart(text));
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        if (!that.getClass().equals(this.getClass())) {
            return false;
        }
        return this.getId().equals(((MessageText)that).getId());
    }

    void setRaw(String pRaw) {
        this.raw = pRaw;
        this.expanded = pRaw;
    }

    String getRaw() {
        return this.raw;
    }

    void appendParsed(ITextPart part) {
        if (part != null) {
            this.parsed.add(part);
        }
    }

    List<ITextPart> getParsed() {
        return Collections.unmodifiableList(this.parsed);
    }

    public Object getId() {
        return this.id;
    }

    public String substitute(boolean singleLine, Object[] args) {
        this.expanded = "";
        if (this.parsed == null) {
            if (this.raw == null) {
                return "";
            }
            this.expanded = this.raw;
            return this.expanded;
        }
        if (this.parsed.isEmpty()) {
            StdParser.parse(this.raw, this.parsed);
        }
        StringBuffer sb = new StringBuffer(80);
        for (ITextPart elem : this.parsed) {
            elem.appendPart(sb, singleLine, args);
        }
        this.expanded = sb.toString();
        return this.expanded;
    }

    public String toString() {
        return this.expanded;
    }
}

