/*
 * Decompiled with CFR 0.152.
 */
package no.g9.service;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import no.esito.log.Logger;
import no.esito.spring.aspect.ExceptionHandlerAspect;
import no.g9.service.JGrapeService;
import no.g9.service.print.ExportService;
import no.g9.service.print.G9Print;
import no.g9.service.print.PrintService;
import no.g9.support.Pathfinder;
import no.g9.support.xml.XmlConverter;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.SpringVersion;

public class G9Spring {
    private static final String[] DEFAULT_BEAN_DEFINITIONS = new String[]{"config/ServicesConfiguration.xml", "config/MessagesConfiguration.xml", "config/JGrapeServicesConfiguration.xml", "config/SwingServicesConfiguration.xml", "config/ICEfacesServicesConfiguration.xml", "config/jVineServicesConfiguration.xml"};
    private static final String[] OPTIONAL_BEAN_DEFINITIONS = new String[]{"G9Dataaccess.xml", "ApplicationBeans.xml", "JouteurApplicationBeans.xml", "G9Service.xml"};
    private static List<String> additionalBeanDefinitions = new ArrayList<String>();
    private static Logger logger = Logger.getLogger(G9Spring.class);
    private static ApplicationContextReference applicationContextReference = new ApplicationContextReference();
    private static Set<Class<?>> shouldUseAspect;

    protected G9Spring() {
    }

    public static String[] getDefaultBeanDefinitions() {
        return (String[])DEFAULT_BEAN_DEFINITIONS.clone();
    }

    public static String[] getOptionalBeanDefinitions() {
        return (String[])OPTIONAL_BEAN_DEFINITIONS.clone();
    }

    @Deprecated
    public static void addAdditionalBeanDefinition(String fileName) {
        logger.debug("Adding additional bean definition " + fileName);
        boolean issueWarning = true;
        G9Spring.checkResource(fileName, issueWarning);
        additionalBeanDefinitions.add(fileName);
        logger.info("Added spring bean definition file " + fileName);
    }

    public static <T> T getBean(Class<T> serviceInterface, String beanID) {
        Object bean = G9Spring.getApplicationContext().getBean(beanID);
        if (logger.isDebugEnabled()) {
            logger.debug("Got bean " + beanID);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(beanID + " is of type " + bean.getClass().getName());
        }
        if (shouldUseAspect.contains(serviceInterface)) {
            ProxyFactory factory = new ProxyFactory(bean);
            factory.addAdvice((Advice)new ExceptionHandlerAspect());
            bean = factory.getProxy();
        }
        return serviceInterface.cast(bean);
    }

    public static <T> T getBean(String beanID) {
        Object bean = G9Spring.getApplicationContext().getBean(beanID);
        if (logger.isDebugEnabled()) {
            logger.debug("Got bean " + beanID);
        }
        if (logger.isTraceEnabled()) {
            logger.trace(beanID + " is of type " + bean.getClass().getName());
        }
        return (T)bean;
    }

    public static synchronized ApplicationContext getApplicationContext() {
        if (applicationContextReference.getApplicationContext() == null) {
            G9Spring.loadApplicationContext();
        }
        return applicationContextReference.getApplicationContext();
    }

    public static synchronized void loadApplicationContext() {
        if (applicationContextReference.getApplicationContext() == null) {
            String[] beanDefinitions = G9Spring.getBeanDefinitions();
            if (logger.isInfoEnabled()) {
                logger.info("Spring version used: " + SpringVersion.getVersion());
                String msg = "Instantiating spring application context using [";
                for (int i = 0; i < beanDefinitions.length - 1; ++i) {
                    msg = msg + beanDefinitions[i] + ", ";
                }
                msg = msg + beanDefinitions[beanDefinitions.length - 1] + "]";
                logger.info(msg);
            }
            ClassPathXmlApplicationContext applicationContext = new ClassPathXmlApplicationContext(beanDefinitions, false);
            applicationContextReference.setApplicationContext((ApplicationContext)applicationContext);
            applicationContext.refresh();
        }
    }

    private static boolean checkResource(String fileName, boolean issueWarning) {
        URL url = Pathfinder.getResourceReference(null, fileName);
        logger.debug("Resource url: " + url);
        if (url != null) {
            logger.info("Found resource " + fileName + " using uri: " + url);
        } else if (issueWarning) {
            logger.warn("Could not locate resource " + fileName);
        }
        return url != null;
    }

    public static String[] getBeanDefinitions() {
        boolean issueWarning;
        ArrayList<String> presentResouces = new ArrayList<String>();
        for (String fileName : DEFAULT_BEAN_DEFINITIONS) {
            issueWarning = false;
            if (!G9Spring.checkResource(fileName, issueWarning)) continue;
            presentResouces.add(fileName);
        }
        for (String fileName : OPTIONAL_BEAN_DEFINITIONS) {
            issueWarning = true;
            if (!G9Spring.checkResource(fileName, issueWarning)) continue;
            presentResouces.add(fileName);
        }
        presentResouces.addAll(additionalBeanDefinitions);
        String[] resources = presentResouces.toArray(new String[0]);
        return resources;
    }

    static {
        Class[] tmp = new Class[]{JGrapeService.class, XmlConverter.class, PrintService.class, ExportService.class, G9Print.class};
        shouldUseAspect = new HashSet();
        shouldUseAspect.addAll(Arrays.asList(tmp));
    }

    public static class ApplicationContextReference {
        private ApplicationContext context;

        public ApplicationContext getApplicationContext() {
            return this.context;
        }

        public void setApplicationContext(ApplicationContext applicationContext) {
            this.context = applicationContext;
        }

        protected final void install() {
            if (applicationContextReference != null) {
                this.setApplicationContext(applicationContextReference.getApplicationContext());
            }
            applicationContextReference = this;
        }
    }
}

