/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.Message;
import no.g9.message.MessageSystem;

public class CustomDate {
    private static String dateInputFormat = "dd.MM.yyyy";
    private static String timeInputFormat = "HH:mm";
    private static String timestampInputFormat = dateInputFormat + " " + timeInputFormat;
    private static String dateOutputFormat = "dd.MM.yyyy";
    private static String timeOutputFormat = "HH:mm";
    private static String timestampOutputFormat = dateOutputFormat + " " + timeOutputFormat;
    private static String dateInternalFormat = "dd.MM.yyyy";
    private static String timeInternalFormat = "HH:mm:ss.SSS";
    private static String timestampInternalFormat = dateInternalFormat + " " + timeInternalFormat;
    private static DateFormat internalDateFormatter;
    private static DateFormat internalTimeFormatter;
    private static DateFormat internalTimestampFormatter;
    private static SimpleDateFormat dateFormatter;

    public static String getDatetimeInputFormat(int datatype) {
        String format = null;
        switch (datatype) {
            case 11: {
                format = dateInputFormat;
                break;
            }
            case 12: {
                format = timeInputFormat;
                break;
            }
            case 13: {
                format = timestampInputFormat;
                break;
            }
        }
        return format;
    }

    public static void setDatetimeInputFormat(int datatype, String format) {
        switch (datatype) {
            case 11: {
                dateInputFormat = format;
                break;
            }
            case 12: {
                timeInputFormat = format;
                break;
            }
            case 13: {
                timestampInputFormat = format;
                break;
            }
        }
    }

    public static String getDatetimeOutputFormat(int datatype) {
        String format = null;
        switch (datatype) {
            case 11: {
                format = dateOutputFormat;
                break;
            }
            case 12: {
                format = timeOutputFormat;
                break;
            }
            case 13: {
                format = timestampOutputFormat;
                break;
            }
        }
        return format;
    }

    public static void setDatetimeOutputFormat(int datatype, String format) {
        switch (datatype) {
            case 11: {
                dateOutputFormat = format;
                break;
            }
            case 12: {
                timeOutputFormat = format;
                break;
            }
            case 13: {
                timestampOutputFormat = format;
                break;
            }
        }
    }

    public static String getDatetimeInternalFormat(int datatype) {
        String format = null;
        switch (datatype) {
            case 11: {
                format = dateInternalFormat;
                break;
            }
            case 12: {
                format = timeInternalFormat;
                break;
            }
            case 13: {
                format = timestampInternalFormat;
                break;
            }
        }
        return format;
    }

    public static DateFormat getDatetimeInternalFormatter(int datatype) {
        DateFormat formatter = null;
        switch (datatype) {
            case 11: {
                formatter = internalDateFormatter;
                if (formatter != null) break;
                formatter = new SimpleDateFormat(CustomDate.getDatetimeInternalFormat(datatype));
                formatter.setLenient(false);
                internalDateFormatter = formatter;
                break;
            }
            case 12: {
                formatter = internalTimeFormatter;
                if (formatter != null) break;
                formatter = new SimpleDateFormat(CustomDate.getDatetimeInternalFormat(datatype));
                formatter.setLenient(false);
                internalTimeFormatter = formatter;
                break;
            }
            case 13: {
                formatter = internalTimestampFormatter;
                if (formatter != null) break;
                formatter = new SimpleDateFormat(CustomDate.getDatetimeInternalFormat(datatype));
                formatter.setLenient(false);
                internalTimestampFormatter = formatter;
                break;
            }
        }
        return formatter;
    }

    public static synchronized String formatInternal(int datatype, Object date) {
        return CustomDate.getDatetimeInternalFormatter(datatype).format(date);
    }

    public static synchronized Date parseInternal(int datatype, String str) throws ParseException {
        return CustomDate.getDatetimeInternalFormatter(datatype).parse(str);
    }

    public static String superDateFormat(String d) {
        if (d == null) {
            return null;
        }
        int length = d.length();
        if (length == 10 || length == 0) {
            return d;
        }
        GregorianCalendar gNow = new GregorianCalendar();
        Date now = new Date();
        gNow.setTime(now);
        int firstDot = d.indexOf(46);
        int lastDot = d.indexOf(46, firstDot + 1);
        if (length <= 3) {
            int day = 0;
            day = firstDot == -1 ? Integer.parseInt(d) : Integer.parseInt(d.substring(0, firstDot));
            if (day < gNow.get(5)) {
                gNow.add(2, 1);
            }
            gNow.set(5, day);
            return CustomDate.getDateFormatter().format(gNow.getTime());
        }
        if (length <= 6) {
            int day = Integer.parseInt(d.substring(0, firstDot));
            int month = 0;
            month = lastDot == -1 || firstDot == lastDot ? Integer.parseInt(d.substring(firstDot + 1, length)) : Integer.parseInt(d.substring(firstDot + 1, lastDot));
            if (month < gNow.get(2)) {
                gNow.add(1, 1);
            }
            gNow.set(2, month - 1);
            gNow.set(5, day);
            return CustomDate.getDateFormatter().format(gNow.getTime());
        }
        if (length == 7) {
            int currentYear = gNow.get(1);
            String currentYearString = Integer.toString(currentYear);
            if (currentYearString.charAt(3) == d.charAt(length - 1)) {
                StringBuffer buff = new StringBuffer(d);
                buff.insert(buff.length() - 1, currentYearString.charAt(2));
                d = buff.toString();
            }
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yy");
            Date desired = null;
            try {
                desired = formatter.parse(d);
            }
            catch (ParseException e) {
                String msgID = "-1515";
                Object[] msgArgs = new Object[]{"no.g9.support.CustomDate.superDateFormat", d, e.getMessage()};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException(e, msg);
            }
            return CustomDate.getDateFormatter().format(desired);
        }
        if (length == 8) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yy");
            Date desired = null;
            try {
                desired = formatter.parse(d);
            }
            catch (ParseException e) {
                String msgID = "-1515";
                Object[] msgArgs = new Object[]{"no.g9.support.CustomDate.superDateFormat", d, e.getMessage()};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException(e, msg);
            }
            return CustomDate.getDateFormatter().format(desired);
        }
        return d;
    }

    @Deprecated
    public static String getDateFormat() {
        return dateInputFormat;
    }

    @Deprecated
    public static String getDatetimeFormat(int datatype) {
        return CustomDate.getDatetimeInputFormat(datatype);
    }

    @Deprecated
    public static SimpleDateFormat getDateFormatter() {
        return dateFormatter;
    }

    @Deprecated
    public static Date parse(String date) {
        try {
            CustomDate.getDateFormatter().setLenient(false);
            return CustomDate.getDateFormatter().parse(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        dateFormatter = new SimpleDateFormat(CustomDate.getDateFormat());
    }
}

