/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support;

import java.math.BigDecimal;

public class Numeric
extends Number
implements Cloneable,
Comparable<Numeric> {
    private static int defaultScale = 0;
    private BigDecimal value;

    @Deprecated
    public Numeric() {
        this.value = BigDecimal.valueOf(0L, defaultScale);
    }

    @Deprecated
    public Numeric(Numeric n) {
        this.value = n.getValue().setScale(defaultScale, 4);
    }

    @Deprecated
    public Numeric(long l) {
        this.value = new BigDecimal(String.valueOf(l)).setScale(defaultScale, 4);
    }

    @Deprecated
    public Numeric(String s) {
        this.value = new BigDecimal(s).setScale(defaultScale, 4);
    }

    @Deprecated
    public Numeric(BigDecimal d) {
        this.value = d.setScale(defaultScale, 4);
    }

    public Numeric(Numeric n, int scale) {
        this.value = n.getValue().setScale(scale, 4);
    }

    public Numeric(long l, int scale) {
        this.value = new BigDecimal(String.valueOf(l)).setScale(scale, 4);
    }

    public Numeric(String s, int scale) {
        this.value = new BigDecimal(s).setScale(scale, 4);
    }

    public Numeric(BigDecimal d, int scale) {
        this.value = d.setScale(scale, 4);
    }

    public int getScale() {
        return this.value.scale();
    }

    public void add(Numeric n) {
        int scale = this.value.scale();
        this.value = this.value.add(n.getValue()).setScale(scale, 4);
    }

    public void add(long l) {
        this.add(new Numeric(l));
    }

    public void subtract(Numeric n) {
        int scale = this.value.scale();
        this.value = this.value.subtract(n.getValue()).setScale(scale, 4);
    }

    public void subtract(long l) {
        this.subtract(new Numeric(l));
    }

    public void multiply(Numeric n) {
        int scale = this.value.scale();
        this.value = this.value.multiply(n.getValue()).setScale(scale, 4);
    }

    public void multiply(long l) {
        this.multiply(new Numeric(l));
    }

    public void multiplyPercent(int i) {
        int scale = this.value.scale();
        BigDecimal tmp = BigDecimal.valueOf(i).movePointLeft(2);
        this.value = this.value.multiply(tmp).setScale(scale, 4);
    }

    public void divide(Numeric n) {
        this.value = this.value.divide(n.getValue(), this.value.scale(), 4);
    }

    public void divide(long l) {
        this.divide(new Numeric(l));
    }

    public void round() {
        int scale = this.value.scale();
        this.value = this.value.setScale(0, 4).setScale(scale);
    }

    public void roundFives() {
        int scale = this.value.scale();
        this.value = this.value.divide(BigDecimal.valueOf(5L), 0, 4);
        this.value = this.value.multiply(BigDecimal.valueOf(5L)).setScale(scale, 4);
    }

    public void roundTens() {
        int scale = this.value.scale();
        this.value = this.value.divide(BigDecimal.valueOf(10L), 0, 4);
        this.value = this.value.multiply(BigDecimal.valueOf(10L)).setScale(scale, 4);
    }

    @Deprecated
    public long getLongValue() {
        return this.value.longValue();
    }

    @Deprecated
    public int getIntValue() {
        return this.value.intValue();
    }

    public int getAsInt100() {
        return this.value.movePointRight(2).intValue();
    }

    @Deprecated
    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    public String toString() {
        return this.value.toString();
    }

    public String toStringWithoutDecimalPoint() {
        return this.value.unscaledValue().toString();
    }

    @Deprecated
    public Numeric makeCopy() {
        return new Numeric(this, this.value.scale());
    }

    public void setValue(BigDecimal value) {
        int scale = this.value.scale();
        this.value = value.setScale(scale, 4);
    }

    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public int compareTo(long l) {
        return this.value.compareTo(BigDecimal.valueOf(l));
    }

    @Override
    public int compareTo(Numeric ob) {
        return this.value.compareTo(ob.getValue());
    }

    public boolean equals(Numeric n) {
        if (n != null) {
            return n.getValue().equals(this.value);
        }
        return false;
    }

    public boolean equals(BigDecimal d) {
        return this.value.equals(d);
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        if (!this.getClass().equals(that.getClass())) {
            return false;
        }
        return this.equals((Numeric)that);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public static int getDefaultScale() {
        return defaultScale;
    }

    public static void setDefaultScale(int scale) {
        defaultScale = scale;
    }

    public void negate() {
        this.value = this.value.negate();
    }

    @Override
    public byte byteValue() {
        return this.value.byteValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public short shortValue() {
        return this.value.shortValue();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)"Clone failed");
        }
    }
}

