/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import no.esito.log.Logger;
import no.g9.exception.G9ServiceException;
import no.g9.service.G9Spring;
import no.g9.support.Registry;

public class Pathfinder {
    private static Logger log = Logger.getLogger(Pathfinder.class);

    private Pathfinder() {
    }

    public static URL getResourceReference(String property, String file) {
        if (log.isDebugEnabled()) {
            log.debug("Getting resource reference for property = " + property + " and file = " + file + ".");
        }
        try {
            File resourceFile = new File(file);
            if (log.isTraceEnabled()) {
                log.trace("Attempting to find resource using absolute path " + file);
            }
            if (resourceFile.isAbsolute()) {
                log.debug("Resource found using file name as absolute path.");
                return resourceFile.toURI().toURL();
            }
            File prefix = new File(Pathfinder.getPropertyValue(property));
            resourceFile = new File(prefix, resourceFile.getPath());
            if (log.isTraceEnabled()) {
                log.trace("Attempting to find resource using " + resourceFile);
            }
            if (prefix.isAbsolute()) {
                log.debug("Resource found using priopertyPath/original_path");
                return resourceFile.toURI().toURL();
            }
            URL url = Pathfinder.getResourceUsingClassLoader(resourceFile);
            if (url != null) {
                return url;
            }
            if (!Pathfinder.isOptional(file)) {
                log.warn("Failed to get URL for resource " + file + ".");
            }
            return null;
        }
        catch (MalformedURLException e) {
            log.error("Malformed URL.", e);
            return null;
        }
        catch (NullPointerException e) {
            log.error("A nullpointer exception was encountered.", e);
            return null;
        }
    }

    private static URL getResourceUsingClassLoader(File resourceFile) {
        URL url;
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        String path = resourceFile.getPath();
        if (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        path = path.replace(File.separatorChar, '/');
        if (log.isTraceEnabled()) {
            log.trace("Attempting to find resource using system class loader classpath/propertyPath/original_path: " + path);
        }
        if ((url = Pathfinder.getURLFromClassLoader(cl, path)) != null) {
            return url;
        }
        cl = Thread.currentThread().getContextClassLoader();
        if (log.isTraceEnabled()) {
            log.trace("Attempting to find resource using context class loader classpath/propertyPath/original_path: " + path);
        }
        url = Pathfinder.getURLFromClassLoader(cl, path);
        return url;
    }

    private static URL getURLFromClassLoader(ClassLoader classLoader, String path) {
        if (classLoader.getResource(path) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Resource found using " + path);
            }
            return classLoader.getResource(path);
        }
        return null;
    }

    public static String getAbsoluteFilePath(URL url) {
        try {
            File tmpFile = new File(url.toURI());
            return tmpFile.getAbsolutePath();
        }
        catch (IllegalArgumentException e) {
            throw new G9ServiceException(e);
        }
        catch (URISyntaxException e) {
            log.error("Malformed URI syntax.", e);
            throw new G9ServiceException(e);
        }
        catch (Exception e) {
            log.error("Unexpected Exception.", e);
            throw new G9ServiceException(e);
        }
    }

    private static String getPropertyValue(String property) {
        if (property == null) {
            return "";
        }
        String regProp = Registry.getRegistry().getG9Property(property);
        return regProp != null ? regProp : "";
    }

    private static boolean isOptional(String resource) {
        for (String definition : G9Spring.getDefaultBeanDefinitions()) {
            if (!resource.equals(definition)) continue;
            return true;
        }
        for (String definition : G9Spring.getOptionalBeanDefinitions()) {
            if (!resource.equals(definition)) continue;
            return true;
        }
        return false;
    }
}

