/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.Collator;
import java.text.ParseException;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import no.g9.exception.G9BaseException;
import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.support.CustomDate;
import no.g9.support.G9Comparator;
import no.g9.support.G9Enumerator;
import no.g9.support.Numeric;

public class TypeTool {
    static Class<? extends Map> defaultMapType = HashMap.class;
    static Class<? extends Set> defaultSetType = HashSet.class;
    static Class<? extends List> defaultListType = ArrayList.class;
    static Class<? extends Collection> defaultCollectionType = HashSet.class;
    private static Collator collator = null;

    private static String msgIllegal(Class<?> argument, String type) {
        return "The specified type (" + argument.getName() + ") does not implement the " + type + " interface";
    }

    private static String msgInstantiate(String type) {
        return "Could not instantiate default " + type;
    }

    private static String msgAccess(String type) {
        return "Could not access default constructor while trying to instansiate default " + type;
    }

    public static final Class<? extends Map> getDefaultMapType() {
        return defaultMapType;
    }

    public static final void setDefaultMapType(Class<? extends Map> mapType) {
        if (!defaultMapType.isAssignableFrom(mapType)) {
            throw new IllegalArgumentException(TypeTool.msgIllegal(mapType, "Map"));
        }
        defaultMapType = mapType;
    }

    public static final <K, V> Map<K, V> getDefaultMap() {
        try {
            return defaultMapType.newInstance();
        }
        catch (InstantiationException e) {
            throw new G9BaseException(TypeTool.msgInstantiate("Map"), e);
        }
        catch (IllegalAccessException e) {
            throw new G9BaseException(TypeTool.msgAccess("Map"), e);
        }
    }

    public static final void setDefaultMap(Map<?, ?> map) {
        defaultMapType = map.getClass();
    }

    public static final Class<? extends Set> getDefaultSetType() {
        return defaultSetType;
    }

    public static final void setDefaultSetType(Class<? extends Set> setType) {
        if (!defaultSetType.isAssignableFrom(setType)) {
            throw new IllegalArgumentException(TypeTool.msgIllegal(setType, "Set"));
        }
        defaultSetType = setType;
    }

    public static final <E> Set<E> getDefaultSet() {
        try {
            return defaultSetType.newInstance();
        }
        catch (InstantiationException e) {
            throw new G9BaseException(TypeTool.msgInstantiate("Set"), e);
        }
        catch (IllegalAccessException e) {
            throw new G9BaseException(TypeTool.msgAccess("Set"), e);
        }
    }

    public static <E> Set<E> reHash(Set<E> serializedSet) {
        Set<E> newSet = TypeTool.getDefaultSet();
        newSet.addAll(serializedSet);
        return newSet;
    }

    public static final void setDefaultSet(Set<?> set) {
        defaultSetType = set.getClass();
    }

    public static final Class<? extends List> getDefaultListType() {
        return defaultListType;
    }

    public static final void setDefaultListType(Class<? extends List> listType) {
        if (!defaultListType.isAssignableFrom(listType)) {
            throw new IllegalArgumentException(TypeTool.msgIllegal(listType, "List"));
        }
        defaultListType = listType;
    }

    public static final <E> List<E> getDefaultList() {
        try {
            return defaultListType.newInstance();
        }
        catch (InstantiationException e) {
            throw new G9BaseException(TypeTool.msgInstantiate("List"), e);
        }
        catch (IllegalAccessException e) {
            throw new G9BaseException(TypeTool.msgAccess("List"), e);
        }
    }

    public static final void setDefaultList(List<?> list) {
        defaultListType = list.getClass();
    }

    public static final Class<? extends Collection> getDefaultCollectionType() {
        return defaultCollectionType;
    }

    public static final void setDefaultCollectionType(Class<? extends Collection> collectionType) {
        if (!defaultCollectionType.isAssignableFrom(collectionType)) {
            throw new IllegalArgumentException(TypeTool.msgIllegal(collectionType, "Collection"));
        }
        defaultCollectionType = collectionType;
    }

    public static final <E> Collection<E> getDefaultCollection() {
        try {
            return defaultCollectionType.newInstance();
        }
        catch (InstantiationException e) {
            throw new G9BaseException(TypeTool.msgInstantiate("Collection"), e);
        }
        catch (IllegalAccessException e) {
            throw new G9BaseException(TypeTool.msgAccess("Collection"), e);
        }
    }

    public static final void setDefaultCollection(Collection<?> collection) {
        defaultCollectionType = collection.getClass();
    }

    public static final boolean isVmVersion(String version) {
        String vmVersion = System.getProperty("java.version");
        return vmVersion != null && vmVersion.startsWith(version);
    }

    public static final boolean isVmVersion1_4() {
        return TypeTool.isVmVersion("1.4");
    }

    @Deprecated
    public static String leadingZeroes(int intToConvert, int length) {
        String tall = "1";
        for (int i = 1; i < length; ++i) {
            tall = tall + "0";
        }
        String tallSomSkal = Integer.toString(intToConvert);
        int diff = tall.length() - tallSomSkal.length();
        StringBuffer tmpTall = null;
        if (diff > 0) {
            tmpTall = new StringBuffer(tallSomSkal);
            for (int teller = 0; teller < diff; ++teller) {
                tmpTall.insert(0, "0");
            }
        } else {
            return String.valueOf(intToConvert);
        }
        return tmpTall.toString();
    }

    /*
     * Exception decompiling
     */
    public static void reflectCopyMethod(Object from, String field, Object to) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String replace(String str, String o, String n, boolean all) {
        int pos;
        if (str == null || o == null || o.length() == 0 || n == null) {
            throw new IllegalArgumentException("null or empty String");
        }
        StringBuffer result = null;
        int oldpos = 0;
        while ((pos = str.indexOf(o, oldpos)) >= 0) {
            if (result == null) {
                result = new StringBuffer();
            }
            result.append(str.substring(oldpos, pos));
            result.append(n);
            oldpos = pos += o.length();
            if (all) continue;
        }
        if (oldpos == 0) {
            return str;
        }
        if (result != null) {
            result.append(str.substring(oldpos));
            return result.toString();
        }
        return null;
    }

    @Deprecated
    public static List disjunctListBinary(List fromLista, List fromListb, G9Comparator objComp) {
        if (fromListb.isEmpty()) {
            return fromLista;
        }
        Collections.sort(fromListb, objComp);
        Vector notInListb = new Vector();
        for (Object a : fromLista) {
            if (Collections.binarySearch(fromListb, a, objComp) >= 0) continue;
            notInListb.add(a);
        }
        return notInListb;
    }

    /*
     * Exception decompiling
     */
    public static void reflectCopy(Object from, String field, Object to) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Map<String, String> quickIndex(String[] tabSequence, boolean next) {
        if (tabSequence == null || tabSequence.length == 0) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> answer = new HashMap<String, String>();
        if (next) {
            for (int i = 0; i < tabSequence.length - 1; ++i) {
                answer.put(tabSequence[i], tabSequence[i + 1]);
            }
            answer.put(tabSequence[tabSequence.length - 1], tabSequence[0]);
        } else {
            for (int i = tabSequence.length - 1; i >= 1; --i) {
                answer.put(tabSequence[i], tabSequence[i - 1]);
            }
            answer.put(tabSequence[0], tabSequence[tabSequence.length - 1]);
        }
        return answer;
    }

    @Deprecated
    public static List disjunctList(List fromLista, List fromListb, G9Comparator objComp) {
        if (fromListb.isEmpty()) {
            return fromLista;
        }
        Vector notInListb = new Vector();
        Iterator listaIterator = fromLista.iterator();
        Iterator listbIterator = fromListb.iterator();
        while (listaIterator.hasNext()) {
            boolean found = false;
            Object a = listaIterator.next();
            while (listbIterator.hasNext()) {
                Object b = listbIterator.next();
                if (!objComp.equals(a, b)) continue;
                found = true;
                break;
            }
            if (!found) {
                notInListb.add(a);
            }
            listbIterator = fromListb.iterator();
        }
        return notInListb;
    }

    @Deprecated
    public static List unionLists(List fromLista, List fromListb, G9Comparator objComp) {
        Vector unionList = new Vector();
        Iterator listaIterator = fromLista.iterator();
        Iterator listbIterator = fromListb.iterator();
        while (listaIterator.hasNext()) {
            Object a = listaIterator.next();
            while (listbIterator.hasNext()) {
                Object b = listbIterator.next();
                if (!objComp.equals(a, b)) continue;
                unionList.add(a);
            }
            listbIterator = fromListb.iterator();
        }
        return unionList;
    }

    /*
     * Exception decompiling
     */
    public static void reflectAssignMethod(Object to, String field, String value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static void reflectAssign(Object to, String field, String value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getAttributeClassNameMethod(Object owner, String field) {
        int lastDot;
        String name;
        NoSuchMethodException ex;
        String msgID;
        block6: {
            msgID = null;
            ex = null;
            if (owner == null) {
                return null;
            }
            String methodName = "get" + field.substring(0, 1).toUpperCase() + field.substring(1);
            Method m = owner.getClass().getMethod(methodName, null);
            name = m.getReturnType().getName();
            lastDot = name.lastIndexOf(46);
            if (lastDot != -1) break block6;
            String string = name;
            if (ex == null) return string;
            Object[] msgArgs = new Object[]{TypeTool.class.getClass(), field, owner.getClass(), ex.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
            MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(ex, msg);
        }
        try {
            String string = name.substring(lastDot + 1);
            if (ex == null) return string;
        }
        catch (NoSuchMethodException e) {
            try {
                ex = e;
                msgID = "-1509";
                if (ex == null) return null;
            }
            catch (Throwable throwable) {
                if (ex == null) throw throwable;
                Object[] msgArgs = new Object[]{TypeTool.class.getClass(), field, owner.getClass(), ex.getMessage()};
                Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException(ex, msg);
            }
            Object[] msgArgs = new Object[]{TypeTool.class.getClass(), field, owner.getClass(), ex.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
            MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(ex, msg);
        }
        Object[] msgArgs = new Object[]{TypeTool.class.getClass(), field, owner.getClass(), ex.getMessage()};
        Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
        MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
        throw new G9ClientFrameworkException(ex, msg);
    }

    public static String getAttributeClassName(Object owner, String field) {
        if (owner == null) {
            return null;
        }
        try {
            Field f = owner.getClass().getField(field);
            String name = f.getType().getName();
            int lastDot = name.lastIndexOf(46);
            if (lastDot == -1) {
                return name;
            }
            return name.substring(lastDot + 1);
        }
        catch (NoSuchFieldException e) {
            Object[] msgArgs = new Object[]{TypeTool.class.getClass(), field, owner.getClass(), e.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
            MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(e, msg);
        }
    }

    public static Object convertIgnore(int primitive, boolean ignoreZero) {
        if (ignoreZero) {
            return TypeTool.convert(primitive);
        }
        return primitive;
    }

    public static Object convert(int primitive) {
        if (primitive == 0) {
            return "";
        }
        return primitive;
    }

    public static Object convertIgnore(short primitive, boolean ignoreZero) {
        if (ignoreZero) {
            return TypeTool.convert(primitive);
        }
        return primitive;
    }

    public static Object convert(short primitive) {
        if (primitive == 0) {
            return "";
        }
        return primitive;
    }

    public static Object convertIgnore(long primitive, boolean ignoreZero) {
        if (ignoreZero) {
            return TypeTool.convert(primitive);
        }
        return primitive;
    }

    public static Object convert(long primitive) {
        if (primitive == 0L) {
            return "";
        }
        return primitive;
    }

    public static Object convertIgnore(double primitive, boolean ignoreZero) {
        if (ignoreZero) {
            return TypeTool.convert(primitive);
        }
        return new Double(primitive);
    }

    public static Object convert(double primitive) {
        if (primitive == 0.0) {
            return "";
        }
        return new Double(primitive);
    }

    public static Object convertIgnore(float primitive, boolean ignoreZero) {
        if (ignoreZero) {
            return TypeTool.convert(primitive);
        }
        return new Float(primitive);
    }

    public static Object convert(float primitive) {
        if (primitive == 0.0f) {
            return "";
        }
        return new Float(primitive);
    }

    public static Boolean convertIgnore(boolean primitive, boolean ignoreZero) {
        return primitive;
    }

    public static Boolean convert(boolean b) {
        return b;
    }

    public static Character convertIgnore(char primitive, boolean ignoreZero) {
        return Character.valueOf(primitive);
    }

    public static Character convert(char primitive) {
        return Character.valueOf(primitive);
    }

    public static String convertIgnore(Numeric n, boolean ignoreZero) {
        if (n == null) {
            if (ignoreZero) {
                return "";
            }
            return "0";
        }
        return n.toString();
    }

    public static String convert(Numeric n) {
        if (n == null) {
            return "";
        }
        return n.toString();
    }

    public static String convertIgnore(G9Enumerator n, boolean ignoreZero) {
        return TypeTool.convert(n);
    }

    public static String convert(G9Enumerator n) {
        if (n == null) {
            return "";
        }
        return String.valueOf(n.currentValue);
    }

    public static Object convertIgnore(Object o, boolean ignoreZero) {
        return TypeTool.convert(o);
    }

    public static Object convert(Object o) {
        if (o == null) {
            return "";
        }
        return o;
    }

    public static Date parse(String arg) {
        return CustomDate.parse(CustomDate.superDateFormat(arg));
    }

    public static Date convert(String day, String month, String year, Date d) {
        return TypeTool.parse(day + month + year);
    }

    public static byte convert(String data, byte field) {
        if (data == null || data.equals("")) {
            return 0;
        }
        field = Byte.valueOf(data);
        return field;
    }

    public static byte convert(byte data, byte field) {
        return data;
    }

    public static short convert(String data, short field) {
        if (data == null || data.equals("")) {
            return 0;
        }
        field = Short.valueOf(data);
        return field;
    }

    public static int convert(String data, int field) {
        if (data == null || data.equals("")) {
            return 0;
        }
        field = Integer.parseInt(data);
        return field;
    }

    public static int convert(int data, int field) {
        return data;
    }

    public static boolean convert(String data, boolean field) {
        if (data == null || data.equals("")) {
            return false;
        }
        field = Boolean.getBoolean(data);
        return field;
    }

    public static boolean convert(boolean data, boolean field) {
        return data;
    }

    public static String convert(String data, String field) {
        return data;
    }

    public static char convert(String data, char field) {
        if (data == null || data.equals("")) {
            return '\u0000';
        }
        field = data.charAt(0);
        return field;
    }

    public static float convert(String data, float field) {
        if (data == null || data.equals("")) {
            return 0.0f;
        }
        field = Float.valueOf(data).floatValue();
        return field;
    }

    public static double convert(String data, double field) {
        if (data == null || data.equals("")) {
            return 0.0;
        }
        field = Double.valueOf(data);
        return field;
    }

    public static long convert(String data, long field) {
        if (data == null || data.equals("")) {
            return 0L;
        }
        field = Long.parseLong(data);
        return field;
    }

    public static Date convert(String data, Date field) {
        return TypeTool.convertToDate(data);
    }

    public static Date convertToDate(String data) {
        if (data == null || data.equals("")) {
            return null;
        }
        return TypeTool.parse(data);
    }

    public static Date convert(Date data, Date field) {
        return data;
    }

    public static Numeric convert(String data, Numeric field) {
        return new Numeric(data, 0);
    }

    public static G9Enumerator convert(String data, G9Enumerator field) {
        G9Enumerator g = new G9Enumerator();
        g.currentValue = Integer.parseInt(data);
        return g;
    }

    public static String convertToString(Object ob, boolean ignoreZero) {
        return TypeTool.convertToString(ob);
    }

    public static String convertToString(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            return String.valueOf(CustomDate.getDateFormatter().format((Date)o));
        }
        return String.valueOf(o);
    }

    public static String convertToString(int i, boolean ignoreZero) {
        if (ignoreZero) {
            return TypeTool.convertToString(i);
        }
        return String.valueOf(i);
    }

    public static String convertToString(int i) {
        if (i == 0) {
            return "";
        }
        return String.valueOf(i);
    }

    public static String convertToString(boolean b) {
        return String.valueOf(b);
    }

    public static String convertToString(boolean b, boolean ignoreZero) {
        return TypeTool.convertToString(b);
    }

    public static String convertToString(char c) {
        return String.valueOf(c);
    }

    public static String convertToString(char c, boolean ignoreZero) {
        return TypeTool.convertToString(c);
    }

    public static String convertToString(float f) {
        if (f == 0.0f) {
            return "";
        }
        return String.valueOf(f);
    }

    public static String convertToString(float f, boolean ignoreZero) {
        if (ignoreZero) {
            return TypeTool.convertToString(f);
        }
        return String.valueOf(f);
    }

    public static String convertToString(double d) {
        if (d == 0.0) {
            return "";
        }
        return String.valueOf(d);
    }

    public static String convertToString(double d, boolean ignoreZero) {
        if (ignoreZero) {
            return TypeTool.convertToString(d);
        }
        return String.valueOf(d);
    }

    public static String convertToString(long l) {
        if (l == 0L) {
            return "";
        }
        return String.valueOf(l);
    }

    public static String convertToString(long l, boolean ignoreZero) {
        if (ignoreZero) {
            return TypeTool.convertToString(l);
        }
        return String.valueOf(l);
    }

    public static boolean convertTobool(Boolean b) {
        return b == null ? false : b;
    }

    public static boolean convertTobool(boolean b) {
        return b;
    }

    public static int convertToInt(int n) {
        return n;
    }

    public static int convertToInt(String arg) {
        if (arg == null) {
            return 0;
        }
        return Integer.parseInt(arg);
    }

    public static int convertToInt(G9Enumerator arg) {
        if (arg == null) {
            return 0;
        }
        return arg.currentValue;
    }

    public static int convertToInt(Numeric arg) {
        if (arg == null) {
            return 0;
        }
        return arg.intValue();
    }

    public static byte safeCopy(byte field) {
        return field;
    }

    public static boolean safeCopy(boolean field) {
        return field;
    }

    public static char safeCopy(char field) {
        return field;
    }

    public static short safeCopy(short field) {
        return field;
    }

    public static int safeCopy(int field) {
        return field;
    }

    public static long safeCopy(long field) {
        return field;
    }

    public static float safeCopy(float field) {
        return field;
    }

    public static double safeCopy(double field) {
        return field;
    }

    public static String safeCopy(String field) {
        return field == null ? null : field;
    }

    public static Date safeCopy(Date field) {
        return field == null ? null : new Date(field.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static G9Enumerator safeCopy(G9Enumerator field) {
        if (field == null) {
            return null;
        }
        String msgID = null;
        ReflectiveOperationException ex = null;
        G9Enumerator g = null;
        try {
            g = (G9Enumerator)field.getClass().newInstance();
            g.currentValue = field.currentValue;
            G9Enumerator g9Enumerator = g;
            if (ex == null) return g9Enumerator;
        }
        catch (IllegalAccessException e) {
            ex = e;
            msgID = "-1509";
            if (ex == null) return null;
            Object[] msgArgs = new Object[]{TypeTool.class.getClass(), field, field.getClass(), ex.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
            MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(ex, msg);
        }
        catch (InstantiationException e2) {
            ex = e2;
            msgID = "-1509";
            if (ex == null) return null;
            {
                catch (Throwable throwable) {
                    if (ex == null) throw throwable;
                    Object[] msgArgs = new Object[]{TypeTool.class.getClass(), field, field.getClass(), ex.getMessage()};
                    Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
                    MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
                    throw new G9ClientFrameworkException(ex, msg);
                }
            }
            Object[] msgArgs = new Object[]{TypeTool.class.getClass(), field, field.getClass(), ex.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
            MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
            throw new G9ClientFrameworkException(ex, msg);
        }
        Object[] msgArgs = new Object[]{TypeTool.class.getClass(), field, field.getClass(), ex.getMessage()};
        Message msg = MessageSystem.getMessageFactory().getMessage(msgID, msgArgs);
        MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
        throw new G9ClientFrameworkException(ex, msg);
    }

    public static Numeric safeCopy(Numeric field) {
        if (field != null) {
            field = (Numeric)field.clone();
        }
        return field;
    }

    @Deprecated
    public static void breakpoint() {
        System.out.println("breakpoint");
    }

    public static boolean equals(long a, long b) {
        return a == b;
    }

    public static boolean equals(double a, double b) {
        return a == b;
    }

    public static boolean equals(boolean a, boolean b) {
        return a == b;
    }

    public static boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static int compareTo(int a, int b) {
        return a - b;
    }

    public static int compareTo(boolean a, boolean b) {
        if (a == b) {
            return 0;
        }
        if (a) {
            return -1;
        }
        if (b) {
            return 1;
        }
        return 0;
    }

    public static int compareTo(long a, long b) {
        return (int)(a - b);
    }

    public static int compareTo(char a, char b) {
        return a - b;
    }

    public static int compareTo(float a, float b) {
        return (int)(a - b);
    }

    public static int compareTo(double a, double b) {
        return (int)(a - b);
    }

    public static int compareTo(Object a, Object b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (a instanceof String && b instanceof String) {
            if (collator == null) {
                collator = Collator.getInstance();
                Locale locale = Locale.getDefault();
                if (TypeTool.isVmVersion1_4() && collator instanceof RuleBasedCollator && (locale.getLanguage().equals(new Locale("no").getLanguage()) || locale.getLanguage().equals(new Locale("da").getLanguage()))) {
                    String r = ((RuleBasedCollator)collator).getRules();
                    r = r.concat("&v,V<w,W");
                    try {
                        collator = new RuleBasedCollator(r);
                        collator.setDecomposition(0);
                    }
                    catch (ParseException e) {
                        collator = Collator.getInstance();
                    }
                }
            }
            String aLow = ((String)a).toLowerCase();
            String bLow = ((String)b).toLowerCase();
            return collator.compare(aLow, bLow);
        }
        if (a instanceof Date && b instanceof Date) {
            return ((Date)a).compareTo((Date)b);
        }
        if (a instanceof Boolean && b instanceof Boolean) {
            return TypeTool.compareTo((Boolean)a, (Boolean)b);
        }
        return ((Comparable)a).compareTo(b);
    }

    public static boolean isEnumeratorMethod(Object owner, String field) {
        String capAttribute = field.substring(0, 1).toUpperCase() + field.substring(1);
        try {
            Method m = owner.getClass().getMethod("get" + capAttribute, null);
            return m.getReturnType().getSuperclass() == G9Enumerator.class || m.getReturnType().isEnum();
        }
        catch (NoSuchMethodException e) {
            try {
                Method m = owner.getClass().getMethod("is" + capAttribute, null);
                return m.getReturnType().getSuperclass() == G9Enumerator.class || m.getReturnType().isEnum();
            }
            catch (NoSuchMethodException e2) {
                Object[] msgArgs = new Object[]{TypeTool.class.getClass(), field, owner.getClass(), e.getMessage()};
                Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
                MessageSystem.getMessageDispatcher(MessageSystem.NO_INTERACTION).dispatch(msg);
                throw new G9ClientFrameworkException(e, msg);
            }
        }
    }

    public static boolean isEnumeratorMethod(int a, String field) {
        return false;
    }

    public static boolean isEnumeratorMethod(boolean a, String field) {
        return false;
    }

    public static boolean isEnumeratorMethod(char a, String field) {
        return false;
    }

    public static boolean isEnumerator(Object owner, String field) {
        return owner instanceof G9Enumerator || owner.getClass().isEnum();
    }

    public static boolean isEnumerator(int a, String field) {
        return false;
    }

    public static boolean isEnumerator(boolean a, String field) {
        return false;
    }

    public static boolean isEnumerator(long a, String field) {
        return false;
    }

    public static boolean isEnumerator(float a, String field) {
        return false;
    }

    public static boolean isEnumerator(char a, String field) {
        return false;
    }

    public static boolean isEnumerator(byte a, String field) {
        return false;
    }

    public static boolean isConsistant(String t, int i) {
        return true;
    }

    public static boolean isConsistant(String t, float i) {
        return true;
    }

    public static boolean isConsistant(String t, double i) {
        return true;
    }

    public static boolean isConsistant(String t, byte i) {
        return true;
    }

    public static boolean isConsistant(String t, char i) {
        return true;
    }

    public static boolean isConsistant(String t, boolean i) {
        return true;
    }

    public static boolean isConsistant(String t, Date d) {
        return TypeTool.convert(t, d) != null;
    }

    public static boolean isConsistant(String t, Object o) {
        return true;
    }

    public static boolean isBoolean(boolean x) {
        return true;
    }

    public static boolean isBoolean(double x) {
        return false;
    }

    public static boolean isBoolean(String x) {
        return false;
    }

    public static boolean isBoolean(int x) {
        return false;
    }

    public static boolean isBoolean(float x) {
        return false;
    }

    public static boolean isBoolean(long x) {
        return false;
    }

    public static boolean isBoolean(Date x) {
        return false;
    }

    public static boolean isBoolean(char x) {
        return false;
    }

    public static boolean isBoolean(Object x) {
        return false;
    }

    public static boolean hasValue(String t) {
        return t != null && !t.equals("");
    }

    public static boolean hasValue(Date d) {
        return d != null;
    }

    public static boolean hasValue(Numeric n) {
        return n != null && n.compareTo(0L) != 0;
    }

    public static boolean hasValue(G9Enumerator e) {
        return e != null && e.currentValue != 0;
    }

    public static boolean hasValue(int primitive) {
        return primitive != 0;
    }

    public static boolean hasValue(boolean primitive) {
        return true;
    }

    public static boolean hasValue(float primitive) {
        return primitive != 0.0f;
    }

    public static boolean hasValue(double primitive) {
        return primitive != 0.0;
    }

    public static boolean hasValue(long primitive) {
        return primitive != 0L;
    }

    public static boolean hasValue(char primitive) {
        return primitive != '\u0000';
    }

    public static boolean hasValue(short primitive) {
        return primitive != 0;
    }

    public static boolean hasValue(byte primitive) {
        return primitive != 0;
    }

    @Deprecated
    public static List uniqueList(List l, G9Comparator comp) {
        if (l == null || l.size() == 0) {
            return l;
        }
        Collections.sort(l, comp);
        Vector retVal = new Vector();
        Iterator i = l.iterator();
        Object current = i.next();
        retVal.add(current);
        while (i.hasNext()) {
            Object next = i.next();
            if (comp.equals(current, next)) continue;
            retVal.add(next);
            current = next;
        }
        return retVal;
    }

    public static String superDateFormat(String d) {
        return CustomDate.superDateFormat(d);
    }

    public static Object toObject(int i) {
        return i;
    }

    public static Object toObject(long l) {
        return l;
    }

    public static Object toObject(byte b) {
        return b;
    }

    public static Object toObject(short s) {
        return s;
    }

    public static Object toObject(boolean b) {
        return b;
    }

    public static Object toObject(double d) {
        return d;
    }

    public static Object toObject(float f) {
        return Float.valueOf(f);
    }

    public static Object toObject(char c) {
        return Character.valueOf(c);
    }

    public static Object toObject(Object o) {
        return o;
    }

    public static String asBeanGetter(String fieldName) {
        StringBuffer methodName = new StringBuffer(fieldName);
        methodName.setCharAt(0, Character.toUpperCase(methodName.charAt(0)));
        return "get" + methodName.toString();
    }

    public static String asBeanBooleanGetter(String fieldName) {
        StringBuffer methodName = new StringBuffer(fieldName);
        methodName.setCharAt(0, Character.toUpperCase(methodName.charAt(0)));
        return "is" + methodName.toString();
    }

    public static String asBeanSetter(String fieldName) {
        StringBuffer methodName = new StringBuffer(fieldName);
        methodName.setCharAt(0, Character.toUpperCase(methodName.charAt(0)));
        return "set" + methodName.toString();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static String stripEnd(String str) {
        int counter;
        if (str == null || str.length() == 0 || !Character.isWhitespace(str.charAt(str.length() - 1))) {
            return str;
        }
        char[] cs = str.toCharArray();
        for (counter = cs.length - 2; counter >= 0 && Character.isWhitespace(cs[counter]); --counter) {
        }
        if (counter == -1) {
            return "";
        }
        return new String(cs, 0, counter + 1);
    }

    public static String getRoleNamePrefix(String roleAttributeName) {
        if (roleAttributeName == null) {
            return null;
        }
        int dotIndex = roleAttributeName.indexOf(46);
        if (dotIndex >= 0) {
            return roleAttributeName.substring(0, dotIndex);
        }
        return null;
    }

    public static String stripRoleNamePrefix(String attr, String roleName) {
        if (attr != null && attr.startsWith(roleName) && attr.length() > roleName.length() + 1 && attr.charAt(roleName.length()) == '.') {
            return attr.substring(roleName.length() + 1);
        }
        return attr;
    }

    public static String addRoleNamePrefix(String attributeName, String roleName) {
        if (!roleName.equals(TypeTool.getRoleNamePrefix(attributeName))) {
            attributeName = roleName + "." + attributeName;
        }
        return attributeName;
    }

    public static final boolean differ(Object value1, Object value2) {
        if (value1 == null) {
            return value2 != null;
        }
        if (value2 == null) {
            return true;
        }
        return !value1.equals(value2) && !value2.equals(value1);
    }

    public static final boolean viewFieldDiffer(Object fieldValue1, Object fieldValue2) {
        boolean differ = TypeTool.differ(fieldValue1, fieldValue2);
        if (differ) {
            boolean stringComparison = false;
            String s1 = "";
            String s2 = "";
            if (fieldValue1 instanceof String) {
                s1 = TypeTool.stripEnd((String)fieldValue1);
                stringComparison = true;
            }
            if (fieldValue2 instanceof String) {
                s2 = TypeTool.stripEnd((String)fieldValue2);
                stringComparison = true;
            }
            if (stringComparison) {
                return !s1.equals(s2);
            }
            boolean boolComparison = false;
            Boolean b1 = Boolean.FALSE;
            Boolean b2 = Boolean.FALSE;
            if (fieldValue1 instanceof Boolean) {
                b1 = (Boolean)fieldValue1;
                boolComparison = true;
            }
            if (fieldValue2 instanceof Boolean) {
                b2 = (Boolean)fieldValue2;
                boolComparison = true;
            }
            if (boolComparison) {
                return !b1.equals(b2);
            }
        }
        return differ;
    }
}

