/*
 * Decompiled with CFR 0.152.
 */
package no.g9.support.transport;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import no.g9.exception.G9ServiceException;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import no.g9.support.G9Enumerator;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.PropertyAccessException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.util.ReflectionUtils;

public class JavaEnumToG9EnumConverterFactory
implements ConverterFactory<Enum, G9Enumerator> {
    private static final String GET_ORDINAL_VALUE_PROPERTY_NAME = "value";

    public <T extends G9Enumerator> Converter<Enum, T> getConverter(Class<T> targetType) {
        return new JavaEnumToG9EnumConverter<T>(targetType);
    }

    private static final class JavaEnumToG9EnumConverter<T extends G9Enumerator>
    implements Converter<Enum, T> {
        private Class<T> g9Type;
        Constructor<T> g9Constructor = null;

        public JavaEnumToG9EnumConverter(Class<T> g9Type) {
            this.g9Type = g9Type;
            try {
                this.g9Constructor = g9Type.getConstructor(Integer.TYPE);
                ReflectionUtils.makeAccessible(this.g9Constructor);
            }
            catch (SecurityException se) {
                this.handleException(g9Type.getSimpleName() + "(int.class)", se);
            }
            catch (NoSuchMethodException nm) {
                this.handleException(g9Type.getSimpleName() + "(int.class)", nm);
            }
        }

        public T convert(Enum source) {
            try {
                if (source == null) {
                    return null;
                }
                Field field = ReflectionUtils.findField(source.getClass(), (String)JavaEnumToG9EnumConverterFactory.GET_ORDINAL_VALUE_PROPERTY_NAME);
                ReflectionUtils.makeAccessible((Field)field);
                Integer ordinalValue = (Integer)ReflectionUtils.getField((Field)field, (Object)source);
                return (T)((G9Enumerator)BeanUtils.instantiateClass(this.g9Constructor, (Object[])new Object[]{ordinalValue}));
            }
            catch (InvalidPropertyException i) {
                this.handleException(JavaEnumToG9EnumConverterFactory.GET_ORDINAL_VALUE_PROPERTY_NAME, (Exception)((Object)i));
            }
            catch (PropertyAccessException i) {
                this.handleException(JavaEnumToG9EnumConverterFactory.GET_ORDINAL_VALUE_PROPERTY_NAME, (Exception)((Object)i));
            }
            catch (BeanInstantiationException bi) {
                this.handleException(this.g9Type.getSimpleName() + "(int.class)", (Exception)((Object)bi));
            }
            catch (BeansException i) {
                this.handleException(JavaEnumToG9EnumConverterFactory.GET_ORDINAL_VALUE_PROPERTY_NAME, (Exception)((Object)i));
            }
            return null;
        }

        private void handleException(String methodOrField, Exception ex) {
            Object[] msgArgs = new Object[]{this.g9Type.getClass(), methodOrField, this.getClass(), ex.getMessage()};
            Message msg = MessageSystem.getMessageFactory().getMessage("-1509", msgArgs);
            throw new G9ServiceException(ex, msg);
        }
    }
}

