/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.message;

import java.io.Serializable;

/**
 * Enumeration type for message constants.
 */
public abstract class MessageEnums implements Serializable {

    /** Numeric value. */
    final Integer code;

    /** Text value. */
    final String name;

    /**
     * Constructor for internal use only.
     * 
     * @param pCode Numeric value.
     * @param pName Textual value.
     */
    MessageEnums(final int pCode, final String pName) {
        this.code = Integer.valueOf(pCode);
        this.name = pName;
    }

    @Override
    public int hashCode() {
        return this.code.hashCode();
    }

    @Override
    public boolean equals(final Object that) {
        if (that == null) return false;
        if (that == this) return true;
        if (this.getClass() != that.getClass()) return false;
        return this.code.equals(((MessageEnums) that).code);
    }

    @Override
    public String toString() {
        return this.name;
    }

    /**
     * Return an integer representing this reply type.
     * 
     * @return Integer code.
     */
    public int toInt() {
        return this.code.intValue();
    }
    
}
