/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.message;


/**
 * Used by the message system to interact with the user. 
 * There can only be one interactor in a configuration.
 */
public interface MessageInteractor {

	/**
	 * Interact with the user. The interactor may choose not to handle this request, in which case the call returns <code>null</code>
	 * @param message The message defining the interaction.
	 * @param dispatcherContext The context in which to interact.
	 * @return The result of the interaction.
	 */
	public MessageReply interact(Message message, DispatcherContext dispatcherContext);

}