/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.os;

import no.g9.exception.G9ClientFrameworkException;
import no.g9.message.Message;

/**
 * Signals that an attribute is missing from an object. This typically occurs
 * when trying to access a non-existent attribute from a domain object.
 */
public class NoSuchAttributeException extends G9ClientFrameworkException {

    /**
     * Constructs a new no such attribute exception with <code>null</code> as
     * its detail message. The cause is not initialized, and may subsequently be
     * initialized by a call to {@link RuntimeException#initCause(Throwable)}.
     */
    public NoSuchAttributeException() {
        super();
    }

    /**
     * Constructs a new no such attribute exception with the specified detail
     * message. The cause is not initialized, and may subsequently be
     * initialized by a call to {@link RuntimeException#initCause(Throwable)}.
     * 
     * @param message the detail message. The detail message is saved for later
     *            retrieval by the {@link #getMessage()} method.
     */
    public NoSuchAttributeException(String message) {
        super(message);
    }

    /**
     * Constructs a new no such attribute exception with the specified detail
     * message and cause.
     * <p>
     * Note that the detail message associated with <code>cause</code> is
     * <i>not</i> automatically incorporated in this no such attribute
     * exception's detail message.
     * 
     * @param message the detail message (which is saved for later retrieval by
     *            the {@link #getMessage()} method).
     * @param cause the cause (which is saved for later retrieval by the
     *            {@link #getCause()} method). (A <tt>null</tt> value is
     *            permitted, and indicates that the cause is nonexistent or
     *            unknown.)
     */
    public NoSuchAttributeException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new no such attribute exception with the specified cause and
     * a detail message of <tt>(cause==null ? null : cause.toString())</tt>
     * (which typically contains the class and detail message of <tt>cause</tt>
     * ). This constructor is useful for no such attribute exceptions that are
     * little more than wrappers for other throwables.
     * 
     * @param cause the cause (which is saved for later retrieval by the
     *            {@link #getCause()} method). (A <tt>null</tt> value is
     *            permitted, and indicates that the cause is nonexistent or
     *            unknown.)
     */
    public NoSuchAttributeException(Throwable cause) {
        super(cause);
    }

    /**
     * Constructs a new no such attribute exception with the specified message.
     * 
     * @param errMsg the message (which is saved for later retrieval by the
     *            {@link #getErrMsg()} method). (A <tt>null</tt> value is
     *            permitted, and indicates that the message is non existant.
     *            Message
     */
    public NoSuchAttributeException(final Message errMsg) {
        super(errMsg);
    }

    /**
     * Constructs a new no such attribute exception with the specified cause and
     * message.
     * 
     * @param cause the cause (saved for later retireval by the
     *            {@link #getCause()} method).
     * @param errMsg the message (saved for later retrieval by the
     *            {@link #getErrMsg()} method).
     */
    public NoSuchAttributeException(final Throwable cause, final Message errMsg) {
        super(cause, errMsg);
    }

}
