/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support;

/**
 * g9 data types etc.
 */
public interface G9Consts {

    /** Data type shortint */
    public static final int DT_SHORTINT = 1;

    /** Data type longint */
    public static final int DT_LONGINT = 2;

    /** Data type numeric */
    public static final int DT_NUMERIC = 3;

    /** Data type real */
    public static final int DT_REAL = 4;

    /** Data type double */
    public static final int DT_DOUBLE = 5;

    /** Data type fixed length text */
    public static final int DT_TEXT = 6;

    /** Data type variable length text */
    public static final int DT_VARTEXT = 7;

    /** Data type long variable length text */
    @Deprecated
    public static final int DT_LONGTEXT = 8;

    /** Data type boolean */
    public static final int DT_BOOLEAN = 9;

    /** Data type enumeration */
    public static final int DT_ENUMERATION = 10;

    /** Data type date */
    public static final int DT_DATE = 11;

    /** Data type time */
    public static final int DT_TIME = 12;

    /** Data type timestamp */
    public static final int DT_TIMESTAMP = 13;

    /** Data type blob */
    public static final int DT_BLOB = 14;
    
    /** Data type longlong */
    public static final int DT_LONGLONG = 15; 

    
    /** Data type shortint name */
    public static final String DT_SHORTINT_NAME = "shortint";

    /** Data type longint name */
    public static final String DT_LONGINT_NAME = "longint";

    /** Data type longlong name */
    public static final String DT_LONGLONG_NAME = "longlong";

    /** Data type numeric name */
    public static final String DT_NUMERIC_NAME = "numeric";

    /** Data type real name */
    public static final String DT_REAL_NAME = "real";

    /** Data type double name */
    public static final String DT_DOUBLE_NAME = "double";

    /** Data type fixed length text name */
    public static final String DT_TEXT_NAME = "text";

    /** Data type variable length text name */
    public static final String DT_VARTEXT_NAME = "vartext";

    /** Data type long variable length text name */
    @Deprecated
    public static final String DT_LONGTEXT_NAME = "longtext";

    /** Data type boolean name */
    public static final String DT_BOOLEAN_NAME = "boolean";

    /** Data type enumeration name */
    public static final String DT_ENUMERATION_NAME = "enumeration";

    /** Data type date name */
    public static final String DT_DATE_NAME = "date";

    /** Data type time name */
    public static final String DT_TIME_NAME = "time";

    /** Data type timestamp name */
    public static final String DT_TIMESTAMP_NAME = "timestamp";

    /** Data type blob name */
    public static final String DT_BLOB_NAME = "blob";

    /** Case conversion, none */
    public static final int CC_NONE = 0;

    /** Case conversion, upper */
    public static final int CC_UPPER = 1;

    /** Case conversion, lower */
    public static final int CC_LOWER = 2;

    /**
     * Helper class for conversion between names and constants.
     */
    public static final class Converter {
        private Converter() {
            /* EMPTY */
        }

        /**
         * Convert from name to constant.
         * 
         * @param name the name of the constant.
         * @return the constant, or -1 if the name was unknown.
         */
        public static int fromName(String name) {
            if (DT_SHORTINT_NAME.equals(name)) {
                return DT_SHORTINT;
            }
            else if (DT_LONGINT_NAME.equals(name)) {
                return DT_LONGINT;
            }
            else if (DT_LONGLONG_NAME.equals(name)) {
                return DT_LONGLONG;
            }
            else if (DT_NUMERIC_NAME.equals(name)) {
                return DT_NUMERIC;
            }
            else if (DT_REAL_NAME.equals(name)) {
                return DT_REAL;
            }
            else if (DT_DOUBLE_NAME.equals(name)) {
                return DT_DOUBLE;
            }
            else if (DT_TEXT_NAME.equals(name)) {
                return DT_TEXT;
            }
            else if (DT_VARTEXT_NAME.equals(name)) {
                return DT_VARTEXT;
            }
            else if (DT_LONGTEXT_NAME.equals(name)) {
                return DT_LONGTEXT;
            }
            else if (DT_BOOLEAN_NAME.equals(name)) {
                return DT_BOOLEAN;
            }
            else if (DT_ENUMERATION_NAME.equals(name)) {
                return DT_ENUMERATION;
            }
            else if (DT_DATE_NAME.equals(name)) {
                return DT_DATE;
            }
            else if (DT_TIME_NAME.equals(name)) {
                return DT_TIME;
            }
            else if (DT_TIMESTAMP_NAME.equals(name)) {
                return DT_TIMESTAMP;
            }
            else if (DT_BLOB_NAME.equals(name)) {
                return DT_BLOB;
            }
            return -1;
        }
    }
 }
