/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support;

/**
 * Used to document the hook type that is applicable for an action.
 *
 *
 */
public enum HookType {
    /** No hooks can be registered on this action type */
    NONE(0),

    /**
     * Hooks that implement the hookable interface can be registered on this
     * kind of actions.
     */
    HOOKABLE(2),

    /**
     * Hooks that implement the checkable interface can be registered on this
     * kind of actions.
     */
    CHECKABLE(4),

    /**
     * Hooks that implement the obtainable interface can be registered on this
     * kind of actions.
     */
    OBTAINABLE(8),

    /**
     * Hooks that implement the clearable interface can be registered on this
     * kind of actions.
     */
    CLEARABLE(16),

    /**
     * Hooks that implement the displayable interface can be registered on this
     * kind of actions.
     */
    DISPLAYABLE(32),

    /**
     * Actions of this kind can be parameterized by special hooks.
     */
    PARAMETERIZED(64);

    /**
     * The bit-mask value.
     */
    public final int MASK;

    /**
     * Construct with mask param
     *
     * @param mask
     *            the mask
     */
    private HookType(int mask) {
        MASK = mask;
    }

}
