/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support.convert;

/**
 * Common interface for value converters.
 *
 * Note that this is not a serialization interface. There is no need that a
 * roundtrip of an Object or String will return an Object that equals to the
 * original Object.
 *
 */
public interface ValueConverter {

    /**
     * Converts a value object to a String.
     *
     * @param value The value object to convert.
     * @param context The context of the value object.
     * @return The value objects converted to a String.
     */
    String convertToString(Object value, ConvertContext context);

    /**
     * Converts a String to an Object.
     *
     * @param value The String to convert.
     * @param context The context of the value object.
     * @return The String converted to an Object.
     */
    Object convertToObject(String value, ConvertContext context);

}
