/*
 * Copyright 2013-2017 Esito AS
 * Licensed under the g9 Runtime License Agreement (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *      http://download.esito.no/licenses/g9runtimelicense.html
 */
package no.g9.support.ws;

import java.util.Collection;

import javax.annotation.Resource;

import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.convert.ConversionService;

/**
 * Abstract template for generated Spring WS Endpoint implementations.
 */
public abstract class AbstractWSEndpoint {

    /*** Conversion service used for conversion to/from domain types etc. **/
    private ConversionService domainTransportConversionService;

    /**
     * Convenience method that converts the <code>source</code> to
     * <code>targetType</code> .
     * 
     * @param <C>
     *            the generic target type
     * @param source
     *            the source to convert
     * @param targetType
     *            the target type to convert to
     * @return the converted object
     */
    protected <C> C convert(Object source, Class<C> targetType) {
        return this.domainTransportConversionService.convert(source, targetType);
    }

    /**
     * Convenience method that converts the <code>source</code> Collection to
     * Collection of <code>targetType</code> objects.
     * 
     * @param <C>
     *            the generic target type
     * @param source
     *            the source Collection to convert
     * @param targetType
     *            the target type to convert to
     * @return the converted collection
     */
    @SuppressWarnings("unchecked")
    protected <C> Collection<C> convert(Collection<?> source, Class<C> targetType) {
        return (Collection<C>) this.domainTransportConversionService.convert(source, targetType);
    }

    /**
     * Sets the <code>ConversionService</code> to use for type and domain to
     * transport conversion.
     * 
     * @param domainTransportConversionService
     *            the <code>ConversionService</code> to use
     */
    @Resource
    @Required
    public void setDomainTransportConversionService(ConversionService domainTransportConversionService) {
        this.domainTransportConversionService = domainTransportConversionService;
    }

}
