/*
 * Decompiled with CFR 0.152.
 */
package no.esito.spring.aspect;

import no.esito.log.Logger;
import no.g9.exception.G9BaseException;
import no.g9.message.Message;
import no.g9.message.MessageSystem;
import org.springframework.aop.ThrowsAdvice;
import org.springframework.remoting.RemoteAccessException;

public class ExceptionHandlerAspect
implements ThrowsAdvice {
    private static Logger log = Logger.getLogger(ExceptionHandlerAspect.class);

    public ExceptionHandlerAspect() {
        log.debug("Finished constructing ExceptionHandlerAspect.");
    }

    public void afterThrowing(Throwable e) throws G9BaseException {
        Throwable ex = e;
        if (ex instanceof RemoteAccessException) {
            ex = this.unwrap(ex);
        }
        if (ex instanceof G9BaseException) {
            throw (G9BaseException)ex;
        }
        throw new G9BaseException(ex, this.makeMessage(ex));
    }

    private Throwable unwrap(Throwable e) {
        return e.getCause() == null ? e : e.getCause();
    }

    private Message makeMessage(Throwable exception) {
        return MessageSystem.getMessageFactory().getMessage("-1000", exception.getMessage());
    }
}

