/*
 * Decompiled with CFR 0.152.
 */
package no.esito.util;

import no.esito.log.Logger;
import no.esito.util.BeanID;
import no.esito.util.G9PropertyName;
import no.g9.exception.G9BaseException;
import no.g9.service.G9Spring;
import no.g9.support.ObjectFactory;
import no.g9.support.Registry;

public final class ServiceLoader {
    private static Logger log = Logger.getLogger(ServiceLoader.class);

    private ServiceLoader() {
    }

    private static <T> String beanID(Class<T> clazz) {
        BeanID beanID = clazz.getAnnotation(BeanID.class);
        return beanID != null ? beanID.value() : null;
    }

    private static <T> String propertyName(Class<T> clazz) {
        G9PropertyName propName = clazz.getAnnotation(G9PropertyName.class);
        return propName != null ? propName.value() : null;
    }

    public static <T> T getService(Class<T> serviceInterface) {
        String beanID;
        T service = null;
        log.info("Instantiating " + serviceInterface.getSimpleName());
        String propertyName = ServiceLoader.propertyName(serviceInterface);
        if (propertyName != null) {
            Registry registry = null;
            try {
                registry = Registry.getRegistry();
            }
            catch (G9BaseException e) {
                log.warn(e.getErrMsg());
            }
            if (registry != null && registry.hasG9Propery(propertyName)) {
                if (log.isDebugEnabled()) {
                    log.debug("Found property for " + propertyName);
                }
                String className = Registry.getRegistry().getG9Property(propertyName);
                if (log.isDebugEnabled()) {
                    log.debug("Setting up " + propertyName + " using " + className);
                }
                Object obj = ObjectFactory.newObject(className);
                service = serviceInterface.cast(obj);
                return service;
            }
        }
        if ((beanID = ServiceLoader.beanID(serviceInterface)) == null) {
            log.error("Missing both property and bean id for " + serviceInterface.getCanonicalName());
            throw new G9BaseException("Failed to load service " + serviceInterface.getSimpleName());
        }
        if (log.isDebugEnabled()) {
            log.debug("Setting up " + propertyName + " as spring bean: \"" + beanID + "\"");
        }
        try {
            service = G9Spring.getBean(serviceInterface, beanID);
        }
        catch (Exception e) {
            log.error("Failed to load bean. Hint: Check class path.", e);
            throw new G9BaseException(e);
        }
        return service;
    }
}

